// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information used to delete the detector model.
 */
public class DeleteDetectorRequest private constructor(builder: Builder) {
    /**
     * The name of the detector model that was used to create the detector instance.
     */
    public val detectorModelName: kotlin.String = requireNotNull(builder.detectorModelName) { "A non-null value must be provided for detectorModelName" }
    /**
     * The value of the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateDetectorModel.html#iotevents-CreateDetectorModel-request-key) used to identify the detector.
     */
    public val keyValue: kotlin.String? = builder.keyValue
    /**
     * The ID to assign to the `DeleteDetectorRequest`. Each `"messageId"` must be unique within each batch sent.
     */
    public val messageId: kotlin.String = requireNotNull(builder.messageId) { "A non-null value must be provided for messageId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.DeleteDetectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDetectorRequest(")
        append("detectorModelName=$detectorModelName,")
        append("keyValue=$keyValue,")
        append("messageId=$messageId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = detectorModelName.hashCode()
        result = 31 * result + (keyValue?.hashCode() ?: 0)
        result = 31 * result + (messageId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDetectorRequest

        if (detectorModelName != other.detectorModelName) return false
        if (keyValue != other.keyValue) return false
        if (messageId != other.messageId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.DeleteDetectorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the detector model that was used to create the detector instance.
         */
        public var detectorModelName: kotlin.String? = null
        /**
         * The value of the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateDetectorModel.html#iotevents-CreateDetectorModel-request-key) used to identify the detector.
         */
        public var keyValue: kotlin.String? = null
        /**
         * The ID to assign to the `DeleteDetectorRequest`. Each `"messageId"` must be unique within each batch sent.
         */
        public var messageId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.DeleteDetectorRequest) : this() {
            this.detectorModelName = x.detectorModelName
            this.keyValue = x.keyValue
            this.messageId = x.messageId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.DeleteDetectorRequest = DeleteDetectorRequest(this)

        internal fun correctErrors(): Builder {
            if (detectorModelName == null) detectorModelName = ""
            if (messageId == null) messageId = ""
            return this
        }
    }
}
