// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ioteventsdata.auth.DefaultIotEventsDataAuthSchemeProvider
import aws.sdk.kotlin.services.ioteventsdata.auth.IotEventsDataAuthSchemeProvider
import aws.sdk.kotlin.services.ioteventsdata.endpoints.DefaultIotEventsDataEndpointProvider
import aws.sdk.kotlin.services.ioteventsdata.endpoints.IotEventsDataEndpointParameters
import aws.sdk.kotlin.services.ioteventsdata.endpoints.IotEventsDataEndpointProvider
import aws.sdk.kotlin.services.ioteventsdata.model.BatchAcknowledgeAlarmRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchAcknowledgeAlarmResponse
import aws.sdk.kotlin.services.ioteventsdata.model.BatchDeleteDetectorRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchDeleteDetectorResponse
import aws.sdk.kotlin.services.ioteventsdata.model.BatchDisableAlarmRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchDisableAlarmResponse
import aws.sdk.kotlin.services.ioteventsdata.model.BatchEnableAlarmRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchEnableAlarmResponse
import aws.sdk.kotlin.services.ioteventsdata.model.BatchPutMessageRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchPutMessageResponse
import aws.sdk.kotlin.services.ioteventsdata.model.BatchResetAlarmRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchResetAlarmResponse
import aws.sdk.kotlin.services.ioteventsdata.model.BatchSnoozeAlarmRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchSnoozeAlarmResponse
import aws.sdk.kotlin.services.ioteventsdata.model.BatchUpdateDetectorRequest
import aws.sdk.kotlin.services.ioteventsdata.model.BatchUpdateDetectorResponse
import aws.sdk.kotlin.services.ioteventsdata.model.DescribeAlarmRequest
import aws.sdk.kotlin.services.ioteventsdata.model.DescribeAlarmResponse
import aws.sdk.kotlin.services.ioteventsdata.model.DescribeDetectorRequest
import aws.sdk.kotlin.services.ioteventsdata.model.DescribeDetectorResponse
import aws.sdk.kotlin.services.ioteventsdata.model.ListAlarmsRequest
import aws.sdk.kotlin.services.ioteventsdata.model.ListAlarmsResponse
import aws.sdk.kotlin.services.ioteventsdata.model.ListDetectorsRequest
import aws.sdk.kotlin.services.ioteventsdata.model.ListDetectorsResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "IoT Events Data"
public const val SdkVersion: String = "1.5.24"
public const val ServiceApiVersion: String = "2018-10-23"

/**
 * IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when such events occur. You can use IoT Events Data API commands to send inputs to detectors, list detectors, and view or update a detector's status.
 *
 *  For more information, see [What is IoT Events?](https://docs.aws.amazon.com/iotevents/latest/developerguide/what-is-iotevents.html) in the *IoT Events Developer Guide*.
 */
public interface IotEventsDataClient : SdkClient {
    /**
     * IotEventsDataClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotEventsDataClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IotEventsData",
                "IOT_EVENTS_DATA",
                "iot_events_data",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotEventsDataClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotEventsDataClient = DefaultIotEventsDataClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotEventsDataEndpointProvider = builder.endpointProvider ?: DefaultIotEventsDataEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotEventsDataAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotEventsDataAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoT Events Data"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotEventsDataEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotEventsDataAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Acknowledges one or more alarms. The alarms change to the `ACKNOWLEDGED` state after you acknowledge them.
     */
    public suspend fun batchAcknowledgeAlarm(input: BatchAcknowledgeAlarmRequest): BatchAcknowledgeAlarmResponse

    /**
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in the [ListDetectors](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html) API call.
     */
    public suspend fun batchDeleteDetector(input: BatchDeleteDetectorRequest): BatchDeleteDetectorResponse

    /**
     * Disables one or more alarms. The alarms change to the `DISABLED` state after you disable them.
     */
    public suspend fun batchDisableAlarm(input: BatchDisableAlarmRequest): BatchDisableAlarmResponse

    /**
     * Enables one or more alarms. The alarms change to the `NORMAL` state after you enable them.
     */
    public suspend fun batchEnableAlarm(input: BatchEnableAlarmRequest): BatchEnableAlarmResponse

    /**
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify (`"inputName"`) and ingested into any detectors that monitor that input. If multiple messages are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send messages one at a time and wait for a successful response.
     */
    public suspend fun batchPutMessage(input: BatchPutMessageRequest): BatchPutMessageResponse

    /**
     * Resets one or more alarms. The alarms return to the `NORMAL` state after you reset them.
     */
    public suspend fun batchResetAlarm(input: BatchResetAlarmRequest): BatchResetAlarmResponse

    /**
     * Changes one or more alarms to the snooze mode. The alarms change to the `SNOOZE_DISABLED` state after you set them to the snooze mode.
     */
    public suspend fun batchSnoozeAlarm(input: BatchSnoozeAlarmRequest): BatchSnoozeAlarmResponse

    /**
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified detector model.
     */
    public suspend fun batchUpdateDetector(input: BatchUpdateDetectorRequest): BatchUpdateDetectorResponse

    /**
     * Retrieves information about an alarm.
     */
    public suspend fun describeAlarm(input: DescribeAlarmRequest): DescribeAlarmResponse

    /**
     * Returns information about the specified detector (instance).
     */
    public suspend fun describeDetector(input: DescribeDetectorRequest): DescribeDetectorResponse

    /**
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     */
    public suspend fun listAlarms(input: ListAlarmsRequest): ListAlarmsResponse

    /**
     * Lists detectors (the instances of a detector model).
     */
    public suspend fun listDetectors(input: ListDetectorsRequest): ListDetectorsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotEventsDataClient.withConfig(block: IotEventsDataClient.Config.Builder.() -> Unit): IotEventsDataClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotEventsDataClient(newConfig)
}

/**
 * Acknowledges one or more alarms. The alarms change to the `ACKNOWLEDGED` state after you acknowledge them.
 */
public suspend inline fun IotEventsDataClient.batchAcknowledgeAlarm(crossinline block: BatchAcknowledgeAlarmRequest.Builder.() -> Unit): BatchAcknowledgeAlarmResponse = batchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest.Builder().apply(block).build())

/**
 * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in the [ListDetectors](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html) API call.
 */
public suspend inline fun IotEventsDataClient.batchDeleteDetector(crossinline block: BatchDeleteDetectorRequest.Builder.() -> Unit): BatchDeleteDetectorResponse = batchDeleteDetector(BatchDeleteDetectorRequest.Builder().apply(block).build())

/**
 * Disables one or more alarms. The alarms change to the `DISABLED` state after you disable them.
 */
public suspend inline fun IotEventsDataClient.batchDisableAlarm(crossinline block: BatchDisableAlarmRequest.Builder.() -> Unit): BatchDisableAlarmResponse = batchDisableAlarm(BatchDisableAlarmRequest.Builder().apply(block).build())

/**
 * Enables one or more alarms. The alarms change to the `NORMAL` state after you enable them.
 */
public suspend inline fun IotEventsDataClient.batchEnableAlarm(crossinline block: BatchEnableAlarmRequest.Builder.() -> Unit): BatchEnableAlarmResponse = batchEnableAlarm(BatchEnableAlarmRequest.Builder().apply(block).build())

/**
 * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify (`"inputName"`) and ingested into any detectors that monitor that input. If multiple messages are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send messages one at a time and wait for a successful response.
 */
public suspend inline fun IotEventsDataClient.batchPutMessage(crossinline block: BatchPutMessageRequest.Builder.() -> Unit): BatchPutMessageResponse = batchPutMessage(BatchPutMessageRequest.Builder().apply(block).build())

/**
 * Resets one or more alarms. The alarms return to the `NORMAL` state after you reset them.
 */
public suspend inline fun IotEventsDataClient.batchResetAlarm(crossinline block: BatchResetAlarmRequest.Builder.() -> Unit): BatchResetAlarmResponse = batchResetAlarm(BatchResetAlarmRequest.Builder().apply(block).build())

/**
 * Changes one or more alarms to the snooze mode. The alarms change to the `SNOOZE_DISABLED` state after you set them to the snooze mode.
 */
public suspend inline fun IotEventsDataClient.batchSnoozeAlarm(crossinline block: BatchSnoozeAlarmRequest.Builder.() -> Unit): BatchSnoozeAlarmResponse = batchSnoozeAlarm(BatchSnoozeAlarmRequest.Builder().apply(block).build())

/**
 * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified detector model.
 */
public suspend inline fun IotEventsDataClient.batchUpdateDetector(crossinline block: BatchUpdateDetectorRequest.Builder.() -> Unit): BatchUpdateDetectorResponse = batchUpdateDetector(BatchUpdateDetectorRequest.Builder().apply(block).build())

/**
 * Retrieves information about an alarm.
 */
public suspend inline fun IotEventsDataClient.describeAlarm(crossinline block: DescribeAlarmRequest.Builder.() -> Unit): DescribeAlarmResponse = describeAlarm(DescribeAlarmRequest.Builder().apply(block).build())

/**
 * Returns information about the specified detector (instance).
 */
public suspend inline fun IotEventsDataClient.describeDetector(crossinline block: DescribeDetectorRequest.Builder.() -> Unit): DescribeDetectorResponse = describeDetector(DescribeDetectorRequest.Builder().apply(block).build())

/**
 * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
 */
public suspend inline fun IotEventsDataClient.listAlarms(crossinline block: ListAlarmsRequest.Builder.() -> Unit): ListAlarmsResponse = listAlarms(ListAlarmsRequest.Builder().apply(block).build())

/**
 * Lists detectors (the instances of a detector model).
 */
public suspend inline fun IotEventsDataClient.listDetectors(crossinline block: ListDetectorsRequest.Builder.() -> Unit): ListDetectorsResponse = listDetectors(ListDetectorsRequest.Builder().apply(block).build())
