// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.serde

import aws.sdk.kotlin.services.iotevents.model.AlarmCapabilities
import aws.sdk.kotlin.services.iotevents.model.AlarmEventActions
import aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionStatus
import aws.sdk.kotlin.services.iotevents.model.AlarmNotification
import aws.sdk.kotlin.services.iotevents.model.AlarmRule
import aws.sdk.kotlin.services.iotevents.model.DescribeAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.IotEventsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeAlarmModelOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAlarmModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAlarmModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAlarmModelError(context, call, payload)
        }
        val builder = DescribeAlarmModelResponse.Builder()

        if (payload != null) {
            deserializeDescribeAlarmModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAlarmModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotEventsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotEventsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAlarmModelOperationBody(builder: DescribeAlarmModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALARMCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmCapabilities"))
    val ALARMEVENTACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmEventActions"))
    val ALARMMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelArn"))
    val ALARMMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelDescription"))
    val ALARMMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelName"))
    val ALARMMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelVersion"))
    val ALARMNOTIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmNotification"))
    val ALARMRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmRule"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("key"))
    val LASTUPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdateTime"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("severity"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMCAPABILITIES_DESCRIPTOR)
        field(ALARMEVENTACTIONS_DESCRIPTOR)
        field(ALARMMODELARN_DESCRIPTOR)
        field(ALARMMODELDESCRIPTION_DESCRIPTOR)
        field(ALARMMODELNAME_DESCRIPTOR)
        field(ALARMMODELVERSION_DESCRIPTOR)
        field(ALARMNOTIFICATION_DESCRIPTOR)
        field(ALARMRULE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(KEY_DESCRIPTOR)
        field(LASTUPDATETIME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SEVERITY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALARMCAPABILITIES_DESCRIPTOR.index -> builder.alarmCapabilities = deserializeAlarmCapabilitiesDocument(deserializer)
                ALARMEVENTACTIONS_DESCRIPTOR.index -> builder.alarmEventActions = deserializeAlarmEventActionsDocument(deserializer)
                ALARMMODELARN_DESCRIPTOR.index -> builder.alarmModelArn = deserializeString()
                ALARMMODELDESCRIPTION_DESCRIPTOR.index -> builder.alarmModelDescription = deserializeString()
                ALARMMODELNAME_DESCRIPTOR.index -> builder.alarmModelName = deserializeString()
                ALARMMODELVERSION_DESCRIPTOR.index -> builder.alarmModelVersion = deserializeString()
                ALARMNOTIFICATION_DESCRIPTOR.index -> builder.alarmNotification = deserializeAlarmNotificationDocument(deserializer)
                ALARMRULE_DESCRIPTOR.index -> builder.alarmRule = deserializeAlarmRuleDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                KEY_DESCRIPTOR.index -> builder.key = deserializeString()
                LASTUPDATETIME_DESCRIPTOR.index -> builder.lastUpdateTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SEVERITY_DESCRIPTOR.index -> builder.severity = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AlarmModelVersionStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
