// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
 */
public class SqsAction private constructor(builder: Builder) {
    /**
     * You can configure the action payload when you send a message to an Amazon SQS queue.
     */
    public val payload: aws.sdk.kotlin.services.iotevents.model.Payload? = builder.payload
    /**
     * The URL of the SQS queue where the data is written.
     */
    public val queueUrl: kotlin.String = requireNotNull(builder.queueUrl) { "A non-null value must be provided for queueUrl" }
    /**
     * Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
     */
    public val useBase64: kotlin.Boolean? = builder.useBase64

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.SqsAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SqsAction(")
        append("payload=$payload,")
        append("queueUrl=$queueUrl,")
        append("useBase64=$useBase64")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = payload?.hashCode() ?: 0
        result = 31 * result + (queueUrl.hashCode())
        result = 31 * result + (useBase64?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SqsAction

        if (payload != other.payload) return false
        if (queueUrl != other.queueUrl) return false
        if (useBase64 != other.useBase64) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.SqsAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * You can configure the action payload when you send a message to an Amazon SQS queue.
         */
        public var payload: aws.sdk.kotlin.services.iotevents.model.Payload? = null
        /**
         * The URL of the SQS queue where the data is written.
         */
        public var queueUrl: kotlin.String? = null
        /**
         * Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
         */
        public var useBase64: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.SqsAction) : this() {
            this.payload = x.payload
            this.queueUrl = x.queueUrl
            this.useBase64 = x.useBase64
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.SqsAction = SqsAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.Payload] inside the given [block]
         */
        public fun payload(block: aws.sdk.kotlin.services.iotevents.model.Payload.Builder.() -> kotlin.Unit) {
            this.payload = aws.sdk.kotlin.services.iotevents.model.Payload.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (queueUrl == null) queueUrl = ""
            return this
        }
    }
}
