// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The values of the AWS IoT Events logging options.
 */
public class LoggingOptions private constructor(builder: Builder) {
    /**
     * Information that identifies those detector models and their detectors (instances) for which the logging level is given.
     */
    public val detectorDebugOptions: List<DetectorDebugOption>? = builder.detectorDebugOptions
    /**
     * If TRUE, logging is enabled for AWS IoT Events.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * The logging level.
     */
    public val level: aws.sdk.kotlin.services.iotevents.model.LoggingLevel = requireNotNull(builder.level) { "A non-null value must be provided for level" }
    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform logging.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.LoggingOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingOptions(")
        append("detectorDebugOptions=$detectorDebugOptions,")
        append("enabled=$enabled,")
        append("level=$level,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = detectorDebugOptions?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (level.hashCode())
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingOptions

        if (detectorDebugOptions != other.detectorDebugOptions) return false
        if (enabled != other.enabled) return false
        if (level != other.level) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.LoggingOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information that identifies those detector models and their detectors (instances) for which the logging level is given.
         */
        public var detectorDebugOptions: List<DetectorDebugOption>? = null
        /**
         * If TRUE, logging is enabled for AWS IoT Events.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * The logging level.
         */
        public var level: aws.sdk.kotlin.services.iotevents.model.LoggingLevel? = null
        /**
         * The ARN of the role that grants permission to AWS IoT Events to perform logging.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.LoggingOptions) : this() {
            this.detectorDebugOptions = x.detectorDebugOptions
            this.enabled = x.enabled
            this.level = x.level
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.LoggingOptions = LoggingOptions(this)

        internal fun correctErrors(): Builder {
            if (level == null) level = LoggingLevel.SdkUnknown("no value provided")
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
