// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.
 *
 * You must use expressions for all parameters in `IotSiteWiseAction`. The expressions accept literals, operators, functions, references, and substitutions templates.
 *
 * **Examples**
 * + For literal values, the expressions must contain single quotes. For example, the value for the `propertyAlias` parameter can be `'/company/windfarm/3/turbine/7/temperature'`.
 * + For references, you must specify either variables or input values. For example, the value for the `assetId` parameter can be `$input.TurbineInput.assetId1`.
 * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `propertyAlias` parameter uses a substitution template. `'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`
 *
 * You must specify either `propertyAlias` or both `assetId` and `propertyId` to identify the target asset property in AWS IoT SiteWise.
 *
 * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
 */
public class IotSiteWiseAction private constructor(builder: Builder) {
    /**
     * The ID of the asset that has the specified property.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
     */
    public val entryId: kotlin.String? = builder.entryId
    /**
     * The alias of the asset property.
     */
    public val propertyAlias: kotlin.String? = builder.propertyAlias
    /**
     * The ID of the asset property.
     */
    public val propertyId: kotlin.String? = builder.propertyId
    /**
     * The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
     */
    public val propertyValue: aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue? = builder.propertyValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IotSiteWiseAction(")
        append("assetId=$assetId,")
        append("entryId=$entryId,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("propertyValue=$propertyValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (entryId?.hashCode() ?: 0)
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (propertyValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IotSiteWiseAction

        if (assetId != other.assetId) return false
        if (entryId != other.entryId) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (propertyValue != other.propertyValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset that has the specified property.
         */
        public var assetId: kotlin.String? = null
        /**
         * A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
         */
        public var entryId: kotlin.String? = null
        /**
         * The alias of the asset property.
         */
        public var propertyAlias: kotlin.String? = null
        /**
         * The ID of the asset property.
         */
        public var propertyId: kotlin.String? = null
        /**
         * The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
         */
        public var propertyValue: aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction) : this() {
            this.assetId = x.assetId
            this.entryId = x.entryId
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.propertyValue = x.propertyValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction = IotSiteWiseAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue] inside the given [block]
         */
        public fun propertyValue(block: aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue.Builder.() -> kotlin.Unit) {
            this.propertyValue = aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
