// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
 */
public class FirehoseAction private constructor(builder: Builder) {
    /**
     * The name of the Kinesis Data Firehose delivery stream where the data is written.
     */
    public val deliveryStreamName: kotlin.String = requireNotNull(builder.deliveryStreamName) { "A non-null value must be provided for deliveryStreamName" }
    /**
     * You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.
     */
    public val payload: aws.sdk.kotlin.services.iotevents.model.Payload? = builder.payload
    /**
     * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    public val separator: kotlin.String? = builder.separator

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.FirehoseAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirehoseAction(")
        append("deliveryStreamName=$deliveryStreamName,")
        append("payload=$payload,")
        append("separator=$separator")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryStreamName.hashCode()
        result = 31 * result + (payload?.hashCode() ?: 0)
        result = 31 * result + (separator?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirehoseAction

        if (deliveryStreamName != other.deliveryStreamName) return false
        if (payload != other.payload) return false
        if (separator != other.separator) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.FirehoseAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Kinesis Data Firehose delivery stream where the data is written.
         */
        public var deliveryStreamName: kotlin.String? = null
        /**
         * You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.
         */
        public var payload: aws.sdk.kotlin.services.iotevents.model.Payload? = null
        /**
         * A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         */
        public var separator: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.FirehoseAction) : this() {
            this.deliveryStreamName = x.deliveryStreamName
            this.payload = x.payload
            this.separator = x.separator
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.FirehoseAction = FirehoseAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.Payload] inside the given [block]
         */
        public fun payload(block: aws.sdk.kotlin.services.iotevents.model.Payload.Builder.() -> kotlin.Unit) {
            this.payload = aws.sdk.kotlin.services.iotevents.model.Payload.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (deliveryStreamName == null) deliveryStreamName = ""
            return this
        }
    }
}
