// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of an alarm model version.
 */
public class AlarmModelVersionSummary private constructor(builder: Builder) {
    /**
     * The ARN of the alarm model. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val alarmModelArn: kotlin.String? = builder.alarmModelArn
    /**
     * The name of the alarm model.
     */
    public val alarmModelName: kotlin.String? = builder.alarmModelName
    /**
     * The version of the alarm model.
     */
    public val alarmModelVersion: kotlin.String? = builder.alarmModelVersion
    /**
     * The time the alarm model was created, in the Unix epoch format.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time the alarm model was last updated, in the Unix epoch format.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the alarm model. The status can be one of the following values:
     * + `ACTIVE` - The alarm model is active and it's ready to evaluate data.
     * + `ACTIVATING` - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.
     * + `INACTIVE` - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.
     * + `FAILED` - You couldn't create or update the alarm model. Check your alarm model information and try again.
     */
    public val status: aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionStatus? = builder.status
    /**
     * Contains information about the status of the alarm model version.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmModelVersionSummary(")
        append("alarmModelArn=$alarmModelArn,")
        append("alarmModelName=$alarmModelName,")
        append("alarmModelVersion=$alarmModelVersion,")
        append("creationTime=$creationTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmModelArn?.hashCode() ?: 0
        result = 31 * result + (alarmModelName?.hashCode() ?: 0)
        result = 31 * result + (alarmModelVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmModelVersionSummary

        if (alarmModelArn != other.alarmModelArn) return false
        if (alarmModelName != other.alarmModelName) return false
        if (alarmModelVersion != other.alarmModelVersion) return false
        if (creationTime != other.creationTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the alarm model. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var alarmModelArn: kotlin.String? = null
        /**
         * The name of the alarm model.
         */
        public var alarmModelName: kotlin.String? = null
        /**
         * The version of the alarm model.
         */
        public var alarmModelVersion: kotlin.String? = null
        /**
         * The time the alarm model was created, in the Unix epoch format.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the alarm model was last updated, in the Unix epoch format.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the alarm model. The status can be one of the following values:
         * + `ACTIVE` - The alarm model is active and it's ready to evaluate data.
         * + `ACTIVATING` - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.
         * + `INACTIVE` - The alarm model is inactive, so it isn't ready to evaluate data. Check your alarm model information and update the alarm model.
         * + `FAILED` - You couldn't create or update the alarm model. Check your alarm model information and try again.
         */
        public var status: aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionStatus? = null
        /**
         * Contains information about the status of the alarm model version.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionSummary) : this() {
            this.alarmModelArn = x.alarmModelArn
            this.alarmModelName = x.alarmModelName
            this.alarmModelVersion = x.alarmModelVersion
            this.creationTime = x.creationTime
            this.lastUpdateTime = x.lastUpdateTime
            this.roleArn = x.roleArn
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionSummary = AlarmModelVersionSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
