// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies one of the following actions to receive notifications when the alarm state changes.
 */
public class AlarmAction private constructor(builder: Builder) {
    /**
     * Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
     *
     * You must use expressions for all parameters in `DynamoDBAction`. The expressions accept literals, operators, functions, references, and substitution templates.
     *
     * **Examples**
     * + For literal values, the expressions must contain single quotes. For example, the value for the `hashKeyType` parameter can be `'STRING'`.
     * + For references, you must specify either variables or input values. For example, the value for the `hashKeyField` parameter can be `$input.GreenhouseInput.name`.
     * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `hashKeyValue` parameter uses a substitution template. `'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`
     * + For a string concatenation, you must use `+`. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `tableName` parameter uses a string concatenation. `'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`
     *
     * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
     *
     * If the defined payload type is a string, `DynamoDBAction` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the `payloadField` parameter is `<payload-field>_raw`.
     */
    public val dynamoDb: aws.sdk.kotlin.services.iotevents.model.DynamoDbAction? = builder.dynamoDb
    /**
     * Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
     *
     * You must use expressions for all parameters in `DynamoDBv2Action`. The expressions accept literals, operators, functions, references, and substitution templates.
     *
     * **Examples**
     * + For literal values, the expressions must contain single quotes. For example, the value for the `tableName` parameter can be `'GreenhouseTemperatureTable'`.
     * + For references, you must specify either variables or input values. For example, the value for the `tableName` parameter can be `$variable.ddbtableName`.
     * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `contentExpression` parameter in `Payload` uses a substitution template. `'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'`
     * + For a string concatenation, you must use `+`. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `tableName` parameter uses a string concatenation. `'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`
     *
     * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
     *
     * The value for the `type` parameter in `Payload` must be `JSON`.
     */
    public val dynamoDbV2: aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action? = builder.dynamoDbV2
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
     */
    public val firehose: aws.sdk.kotlin.services.iotevents.model.FirehoseAction? = builder.firehose
    /**
     * Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
     */
    public val iotEvents: aws.sdk.kotlin.services.iotevents.model.IotEventsAction? = builder.iotEvents
    /**
     * Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.
     *
     * You must use expressions for all parameters in `IotSiteWiseAction`. The expressions accept literals, operators, functions, references, and substitutions templates.
     *
     * **Examples**
     * + For literal values, the expressions must contain single quotes. For example, the value for the `propertyAlias` parameter can be `'/company/windfarm/3/turbine/7/temperature'`.
     * + For references, you must specify either variables or input values. For example, the value for the `assetId` parameter can be `$input.TurbineInput.assetId1`.
     * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `propertyAlias` parameter uses a substitution template. `'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`
     *
     * You must specify either `propertyAlias` or both `assetId` and `propertyId` to identify the target asset property in AWS IoT SiteWise.
     *
     * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
     */
    public val iotSiteWise: aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction? = builder.iotSiteWise
    /**
     * Information required to publish the MQTT message through the AWS IoT message broker.
     */
    public val iotTopicPublish: aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction? = builder.iotTopicPublish
    /**
     * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
     */
    public val lambda: aws.sdk.kotlin.services.iotevents.model.LambdaAction? = builder.lambda
    /**
     * Information required to publish the Amazon SNS message.
     */
    public val sns: aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction? = builder.sns
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
     */
    public val sqs: aws.sdk.kotlin.services.iotevents.model.SqsAction? = builder.sqs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.AlarmAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmAction(")
        append("dynamoDb=$dynamoDb,")
        append("dynamoDbV2=$dynamoDbV2,")
        append("firehose=$firehose,")
        append("iotEvents=$iotEvents,")
        append("iotSiteWise=$iotSiteWise,")
        append("iotTopicPublish=$iotTopicPublish,")
        append("lambda=$lambda,")
        append("sns=$sns,")
        append("sqs=$sqs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dynamoDb?.hashCode() ?: 0
        result = 31 * result + (dynamoDbV2?.hashCode() ?: 0)
        result = 31 * result + (firehose?.hashCode() ?: 0)
        result = 31 * result + (iotEvents?.hashCode() ?: 0)
        result = 31 * result + (iotSiteWise?.hashCode() ?: 0)
        result = 31 * result + (iotTopicPublish?.hashCode() ?: 0)
        result = 31 * result + (lambda?.hashCode() ?: 0)
        result = 31 * result + (sns?.hashCode() ?: 0)
        result = 31 * result + (sqs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmAction

        if (dynamoDb != other.dynamoDb) return false
        if (dynamoDbV2 != other.dynamoDbV2) return false
        if (firehose != other.firehose) return false
        if (iotEvents != other.iotEvents) return false
        if (iotSiteWise != other.iotSiteWise) return false
        if (iotTopicPublish != other.iotTopicPublish) return false
        if (lambda != other.lambda) return false
        if (sns != other.sns) return false
        if (sqs != other.sqs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.AlarmAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         *
         * You must use expressions for all parameters in `DynamoDBAction`. The expressions accept literals, operators, functions, references, and substitution templates.
         *
         * **Examples**
         * + For literal values, the expressions must contain single quotes. For example, the value for the `hashKeyType` parameter can be `'STRING'`.
         * + For references, you must specify either variables or input values. For example, the value for the `hashKeyField` parameter can be `$input.GreenhouseInput.name`.
         * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `hashKeyValue` parameter uses a substitution template. `'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`
         * + For a string concatenation, you must use `+`. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `tableName` parameter uses a string concatenation. `'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`
         *
         * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
         *
         * If the defined payload type is a string, `DynamoDBAction` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the `payloadField` parameter is `<payload-field>_raw`.
         */
        public var dynamoDb: aws.sdk.kotlin.services.iotevents.model.DynamoDbAction? = null
        /**
         * Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         *
         * You must use expressions for all parameters in `DynamoDBv2Action`. The expressions accept literals, operators, functions, references, and substitution templates.
         *
         * **Examples**
         * + For literal values, the expressions must contain single quotes. For example, the value for the `tableName` parameter can be `'GreenhouseTemperatureTable'`.
         * + For references, you must specify either variables or input values. For example, the value for the `tableName` parameter can be `$variable.ddbtableName`.
         * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `contentExpression` parameter in `Payload` uses a substitution template. `'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'`
         * + For a string concatenation, you must use `+`. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `tableName` parameter uses a string concatenation. `'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`
         *
         * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
         *
         * The value for the `type` parameter in `Payload` must be `JSON`.
         */
        public var dynamoDbV2: aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action? = null
        /**
         * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
         */
        public var firehose: aws.sdk.kotlin.services.iotevents.model.FirehoseAction? = null
        /**
         * Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.
         */
        public var iotEvents: aws.sdk.kotlin.services.iotevents.model.IotEventsAction? = null
        /**
         * Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.
         *
         * You must use expressions for all parameters in `IotSiteWiseAction`. The expressions accept literals, operators, functions, references, and substitutions templates.
         *
         * **Examples**
         * + For literal values, the expressions must contain single quotes. For example, the value for the `propertyAlias` parameter can be `'/company/windfarm/3/turbine/7/temperature'`.
         * + For references, you must specify either variables or input values. For example, the value for the `assetId` parameter can be `$input.TurbineInput.assetId1`.
         * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `propertyAlias` parameter uses a substitution template. `'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`
         *
         * You must specify either `propertyAlias` or both `assetId` and `propertyId` to identify the target asset property in AWS IoT SiteWise.
         *
         * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
         */
        public var iotSiteWise: aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction? = null
        /**
         * Information required to publish the MQTT message through the AWS IoT message broker.
         */
        public var iotTopicPublish: aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction? = null
        /**
         * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
         */
        public var lambda: aws.sdk.kotlin.services.iotevents.model.LambdaAction? = null
        /**
         * Information required to publish the Amazon SNS message.
         */
        public var sns: aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction? = null
        /**
         * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
         */
        public var sqs: aws.sdk.kotlin.services.iotevents.model.SqsAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.AlarmAction) : this() {
            this.dynamoDb = x.dynamoDb
            this.dynamoDbV2 = x.dynamoDbV2
            this.firehose = x.firehose
            this.iotEvents = x.iotEvents
            this.iotSiteWise = x.iotSiteWise
            this.iotTopicPublish = x.iotTopicPublish
            this.lambda = x.lambda
            this.sns = x.sns
            this.sqs = x.sqs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.AlarmAction = AlarmAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.DynamoDbAction] inside the given [block]
         */
        public fun dynamoDb(block: aws.sdk.kotlin.services.iotevents.model.DynamoDbAction.Builder.() -> kotlin.Unit) {
            this.dynamoDb = aws.sdk.kotlin.services.iotevents.model.DynamoDbAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action] inside the given [block]
         */
        public fun dynamoDbV2(block: aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action.Builder.() -> kotlin.Unit) {
            this.dynamoDbV2 = aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.FirehoseAction] inside the given [block]
         */
        public fun firehose(block: aws.sdk.kotlin.services.iotevents.model.FirehoseAction.Builder.() -> kotlin.Unit) {
            this.firehose = aws.sdk.kotlin.services.iotevents.model.FirehoseAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.IotEventsAction] inside the given [block]
         */
        public fun iotEvents(block: aws.sdk.kotlin.services.iotevents.model.IotEventsAction.Builder.() -> kotlin.Unit) {
            this.iotEvents = aws.sdk.kotlin.services.iotevents.model.IotEventsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction] inside the given [block]
         */
        public fun iotSiteWise(block: aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction.Builder.() -> kotlin.Unit) {
            this.iotSiteWise = aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction] inside the given [block]
         */
        public fun iotTopicPublish(block: aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction.Builder.() -> kotlin.Unit) {
            this.iotTopicPublish = aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.LambdaAction] inside the given [block]
         */
        public fun lambda(block: aws.sdk.kotlin.services.iotevents.model.LambdaAction.Builder.() -> kotlin.Unit) {
            this.lambda = aws.sdk.kotlin.services.iotevents.model.LambdaAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction] inside the given [block]
         */
        public fun sns(block: aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction.Builder.() -> kotlin.Unit) {
            this.sns = aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.SqsAction] inside the given [block]
         */
        public fun sqs(block: aws.sdk.kotlin.services.iotevents.model.SqsAction.Builder.() -> kotlin.Unit) {
            this.sqs = aws.sdk.kotlin.services.iotevents.model.SqsAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
