// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.serde

import aws.sdk.kotlin.services.iotevents.model.AlarmCapabilities
import aws.sdk.kotlin.services.iotevents.model.AlarmEventActions
import aws.sdk.kotlin.services.iotevents.model.AlarmNotification
import aws.sdk.kotlin.services.iotevents.model.AlarmRule
import aws.sdk.kotlin.services.iotevents.model.UpdateAlarmModelRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAlarmModelOperationSerializer: HttpSerializer.NonStreaming<UpdateAlarmModelRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAlarmModelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.alarmModelName) { "alarmModelName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("alarm-models"))
                add(PercentEncoding.SmithyLabel.encode(input.alarmModelName))
            }
        }

        val payload = serializeUpdateAlarmModelOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAlarmModelOperationBody(context: ExecutionContext, input: UpdateAlarmModelRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALARMCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmCapabilities"))
    val ALARMEVENTACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmEventActions"))
    val ALARMMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelDescription"))
    val ALARMNOTIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmNotification"))
    val ALARMRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmRule"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("severity"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMCAPABILITIES_DESCRIPTOR)
        field(ALARMEVENTACTIONS_DESCRIPTOR)
        field(ALARMMODELDESCRIPTION_DESCRIPTOR)
        field(ALARMNOTIFICATION_DESCRIPTOR)
        field(ALARMRULE_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SEVERITY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alarmCapabilities?.let { field(ALARMCAPABILITIES_DESCRIPTOR, it, ::serializeAlarmCapabilitiesDocument) }
        input.alarmEventActions?.let { field(ALARMEVENTACTIONS_DESCRIPTOR, it, ::serializeAlarmEventActionsDocument) }
        input.alarmModelDescription?.let { field(ALARMMODELDESCRIPTION_DESCRIPTOR, it) }
        input.alarmNotification?.let { field(ALARMNOTIFICATION_DESCRIPTOR, it, ::serializeAlarmNotificationDocument) }
        input.alarmRule?.let { field(ALARMRULE_DESCRIPTOR, it, ::serializeAlarmRuleDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.severity?.let { field(SEVERITY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
