// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about your identity source in AWS Single Sign-On. For more information, see the [AWS Single Sign-On User Guide](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html).
 */
public class SsoIdentity private constructor(builder: Builder) {
    /**
     * The ID of the AWS SSO identity store.
     */
    public val identityStoreId: kotlin.String = requireNotNull(builder.identityStoreId) { "A non-null value must be provided for identityStoreId" }
    /**
     * The user ID.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.SsoIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SsoIdentity(")
        append("identityStoreId=$identityStoreId,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityStoreId.hashCode()
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SsoIdentity

        if (identityStoreId != other.identityStoreId) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.SsoIdentity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the AWS SSO identity store.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * The user ID.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.SsoIdentity) : this() {
            this.identityStoreId = x.identityStoreId
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.SsoIdentity = SsoIdentity(this)

        internal fun correctErrors(): Builder {
            if (identityStoreId == null) identityStoreId = ""
            return this
        }
    }
}
