// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information needed to set the timer.
 */
public class SetTimerAction private constructor(builder: Builder) {
    /**
     * The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (`$variable.<variable-name>`), and input values (`$input.<input-name>.<path-to-datum>`) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
     */
    public val durationExpression: kotlin.String? = builder.durationExpression
    /**
     * The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
     */
    @Deprecated("seconds is deprecated. You can use durationExpression for SetTimerAction. The value of seconds can be used as a string expression for durationExpression.")
    public val seconds: kotlin.Int? = builder.seconds
    /**
     * The name of the timer.
     */
    public val timerName: kotlin.String = requireNotNull(builder.timerName) { "A non-null value must be provided for timerName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.SetTimerAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetTimerAction(")
        append("durationExpression=$durationExpression,")
        append("seconds=$seconds,")
        append("timerName=$timerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationExpression?.hashCode() ?: 0
        result = 31 * result + (seconds ?: 0)
        result = 31 * result + (timerName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetTimerAction

        if (durationExpression != other.durationExpression) return false
        if (seconds != other.seconds) return false
        if (timerName != other.timerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.SetTimerAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (`$variable.<variable-name>`), and input values (`$input.<input-name>.<path-to-datum>`) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
         */
        public var durationExpression: kotlin.String? = null
        /**
         * The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
         */
        @Deprecated("seconds is deprecated. You can use durationExpression for SetTimerAction. The value of seconds can be used as a string expression for durationExpression.")
        public var seconds: kotlin.Int? = null
        /**
         * The name of the timer.
         */
        public var timerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.SetTimerAction) : this() {
            this.durationExpression = x.durationExpression
            this.seconds = x.seconds
            this.timerName = x.timerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.SetTimerAction = SetTimerAction(this)

        internal fun correctErrors(): Builder {
            if (timerName == null) timerName = ""
            return this
        }
    }
}
