// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information required to publish the MQTT message through the AWS IoT message broker.
 */
public class IotTopicPublishAction private constructor(builder: Builder) {
    /**
     * The MQTT topic of the message. You can use a string expression that includes variables (`$variable.<variable-name>`) and input values (`$input.<input-name>.<path-to-datum>`) as the topic string.
     */
    public val mqttTopic: kotlin.String = requireNotNull(builder.mqttTopic) { "A non-null value must be provided for mqttTopic" }
    /**
     * You can configure the action payload when you publish a message to an AWS IoT Core topic.
     */
    public val payload: aws.sdk.kotlin.services.iotevents.model.Payload? = builder.payload

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IotTopicPublishAction(")
        append("mqttTopic=$mqttTopic,")
        append("payload=$payload")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mqttTopic.hashCode()
        result = 31 * result + (payload?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IotTopicPublishAction

        if (mqttTopic != other.mqttTopic) return false
        if (payload != other.payload) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The MQTT topic of the message. You can use a string expression that includes variables (`$variable.<variable-name>`) and input values (`$input.<input-name>.<path-to-datum>`) as the topic string.
         */
        public var mqttTopic: kotlin.String? = null
        /**
         * You can configure the action payload when you publish a message to an AWS IoT Core topic.
         */
        public var payload: aws.sdk.kotlin.services.iotevents.model.Payload? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction) : this() {
            this.mqttTopic = x.mqttTopic
            this.payload = x.payload
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction = IotTopicPublishAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.Payload] inside the given [block]
         */
        public fun payload(block: aws.sdk.kotlin.services.iotevents.model.Payload.Builder.() -> kotlin.Unit) {
            this.payload = aws.sdk.kotlin.services.iotevents.model.Payload.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (mqttTopic == null) mqttTopic = ""
            return this
        }
    }
}
