// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the configuration information of email notifications.
 */
public class EmailConfiguration private constructor(builder: Builder) {
    /**
     * Contains the subject and message of an email.
     */
    public val content: aws.sdk.kotlin.services.iotevents.model.EmailContent? = builder.content
    /**
     * The email address that sends emails.
     *
     * If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must [verify the email address that sends emails in Amazon SES](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
     */
    public val from: kotlin.String = requireNotNull(builder.from) { "A non-null value must be provided for from" }
    /**
     * Contains the information of one or more recipients who receive the emails.
     *
     * You must [add the users that receive emails to your AWS SSO store](https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html).
     */
    public val recipients: aws.sdk.kotlin.services.iotevents.model.EmailRecipients? = builder.recipients

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.EmailConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EmailConfiguration(")
        append("content=$content,")
        append("from=$from,")
        append("recipients=$recipients")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (from.hashCode())
        result = 31 * result + (recipients?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EmailConfiguration

        if (content != other.content) return false
        if (from != other.from) return false
        if (recipients != other.recipients) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.EmailConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains the subject and message of an email.
         */
        public var content: aws.sdk.kotlin.services.iotevents.model.EmailContent? = null
        /**
         * The email address that sends emails.
         *
         * If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must [verify the email address that sends emails in Amazon SES](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
         */
        public var from: kotlin.String? = null
        /**
         * Contains the information of one or more recipients who receive the emails.
         *
         * You must [add the users that receive emails to your AWS SSO store](https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html).
         */
        public var recipients: aws.sdk.kotlin.services.iotevents.model.EmailRecipients? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.EmailConfiguration) : this() {
            this.content = x.content
            this.from = x.from
            this.recipients = x.recipients
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.EmailConfiguration = EmailConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.EmailContent] inside the given [block]
         */
        public fun content(block: aws.sdk.kotlin.services.iotevents.model.EmailContent.Builder.() -> kotlin.Unit) {
            this.content = aws.sdk.kotlin.services.iotevents.model.EmailContent.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.EmailRecipients] inside the given [block]
         */
        public fun recipients(block: aws.sdk.kotlin.services.iotevents.model.EmailRecipients.Builder.() -> kotlin.Unit) {
            this.recipients = aws.sdk.kotlin.services.iotevents.model.EmailRecipients.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (from == null) from = ""
            return this
        }
    }
}
