// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
 *
 * You must use expressions for all parameters in `DynamoDBAction`. The expressions accept literals, operators, functions, references, and substitution templates.
 *
 * **Examples**
 * + For literal values, the expressions must contain single quotes. For example, the value for the `hashKeyType` parameter can be `'STRING'`.
 * + For references, you must specify either variables or input values. For example, the value for the `hashKeyField` parameter can be `$input.GreenhouseInput.name`.
 * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `hashKeyValue` parameter uses a substitution template. `'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`
 * + For a string concatenation, you must use `+`. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `tableName` parameter uses a string concatenation. `'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`
 *
 * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
 *
 * If the defined payload type is a string, `DynamoDBAction` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the `payloadField` parameter is `<payload-field>_raw`.
 */
public class DynamoDbAction private constructor(builder: Builder) {
    /**
     * The name of the hash key (also called the partition key). The `hashKeyField` value must match the partition key of the target DynamoDB table.
     */
    public val hashKeyField: kotlin.String = requireNotNull(builder.hashKeyField) { "A non-null value must be provided for hashKeyField" }
    /**
     * The data type for the hash key (also called the partition key). You can specify the following values:
     * + `'STRING'` - The hash key is a string.
     * + `'NUMBER'` - The hash key is a number.
     *
     * If you don't specify `hashKeyType`, the default value is `'STRING'`.
     */
    public val hashKeyType: kotlin.String? = builder.hashKeyType
    /**
     * The value of the hash key (also called the partition key).
     */
    public val hashKeyValue: kotlin.String = requireNotNull(builder.hashKeyValue) { "A non-null value must be provided for hashKeyValue" }
    /**
     * The type of operation to perform. You can specify the following values:
     * + `'INSERT'` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
     * + `'UPDATE'` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
     * + `'DELETE'` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
     *
     * If you don't specify this parameter, AWS IoT Events triggers the `'INSERT'` operation.
     */
    public val operation: kotlin.String? = builder.operation
    /**
     * Information needed to configure the payload.
     *
     * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
     */
    public val payload: aws.sdk.kotlin.services.iotevents.model.Payload? = builder.payload
    /**
     * The name of the DynamoDB column that receives the action payload.
     *
     * If you don't specify this parameter, the name of the DynamoDB column is `payload`.
     */
    public val payloadField: kotlin.String? = builder.payloadField
    /**
     * The name of the range key (also called the sort key). The `rangeKeyField` value must match the sort key of the target DynamoDB table.
     */
    public val rangeKeyField: kotlin.String? = builder.rangeKeyField
    /**
     * The data type for the range key (also called the sort key), You can specify the following values:
     * + `'STRING'` - The range key is a string.
     * + `'NUMBER'` - The range key is number.
     *
     * If you don't specify `rangeKeyField`, the default value is `'STRING'`.
     */
    public val rangeKeyType: kotlin.String? = builder.rangeKeyType
    /**
     * The value of the range key (also called the sort key).
     */
    public val rangeKeyValue: kotlin.String? = builder.rangeKeyValue
    /**
     * The name of the DynamoDB table. The `tableName` value must match the table name of the target DynamoDB table.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.DynamoDbAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DynamoDbAction(")
        append("hashKeyField=$hashKeyField,")
        append("hashKeyType=$hashKeyType,")
        append("hashKeyValue=$hashKeyValue,")
        append("operation=$operation,")
        append("payload=$payload,")
        append("payloadField=$payloadField,")
        append("rangeKeyField=$rangeKeyField,")
        append("rangeKeyType=$rangeKeyType,")
        append("rangeKeyValue=$rangeKeyValue,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hashKeyField.hashCode()
        result = 31 * result + (hashKeyType?.hashCode() ?: 0)
        result = 31 * result + (hashKeyValue.hashCode())
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (payload?.hashCode() ?: 0)
        result = 31 * result + (payloadField?.hashCode() ?: 0)
        result = 31 * result + (rangeKeyField?.hashCode() ?: 0)
        result = 31 * result + (rangeKeyType?.hashCode() ?: 0)
        result = 31 * result + (rangeKeyValue?.hashCode() ?: 0)
        result = 31 * result + (tableName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DynamoDbAction

        if (hashKeyField != other.hashKeyField) return false
        if (hashKeyType != other.hashKeyType) return false
        if (hashKeyValue != other.hashKeyValue) return false
        if (operation != other.operation) return false
        if (payload != other.payload) return false
        if (payloadField != other.payloadField) return false
        if (rangeKeyField != other.rangeKeyField) return false
        if (rangeKeyType != other.rangeKeyType) return false
        if (rangeKeyValue != other.rangeKeyValue) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.DynamoDbAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the hash key (also called the partition key). The `hashKeyField` value must match the partition key of the target DynamoDB table.
         */
        public var hashKeyField: kotlin.String? = null
        /**
         * The data type for the hash key (also called the partition key). You can specify the following values:
         * + `'STRING'` - The hash key is a string.
         * + `'NUMBER'` - The hash key is a number.
         *
         * If you don't specify `hashKeyType`, the default value is `'STRING'`.
         */
        public var hashKeyType: kotlin.String? = null
        /**
         * The value of the hash key (also called the partition key).
         */
        public var hashKeyValue: kotlin.String? = null
        /**
         * The type of operation to perform. You can specify the following values:
         * + `'INSERT'` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
         * + `'UPDATE'` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
         * + `'DELETE'` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
         *
         * If you don't specify this parameter, AWS IoT Events triggers the `'INSERT'` operation.
         */
        public var operation: kotlin.String? = null
        /**
         * Information needed to configure the payload.
         *
         * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
         */
        public var payload: aws.sdk.kotlin.services.iotevents.model.Payload? = null
        /**
         * The name of the DynamoDB column that receives the action payload.
         *
         * If you don't specify this parameter, the name of the DynamoDB column is `payload`.
         */
        public var payloadField: kotlin.String? = null
        /**
         * The name of the range key (also called the sort key). The `rangeKeyField` value must match the sort key of the target DynamoDB table.
         */
        public var rangeKeyField: kotlin.String? = null
        /**
         * The data type for the range key (also called the sort key), You can specify the following values:
         * + `'STRING'` - The range key is a string.
         * + `'NUMBER'` - The range key is number.
         *
         * If you don't specify `rangeKeyField`, the default value is `'STRING'`.
         */
        public var rangeKeyType: kotlin.String? = null
        /**
         * The value of the range key (also called the sort key).
         */
        public var rangeKeyValue: kotlin.String? = null
        /**
         * The name of the DynamoDB table. The `tableName` value must match the table name of the target DynamoDB table.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.DynamoDbAction) : this() {
            this.hashKeyField = x.hashKeyField
            this.hashKeyType = x.hashKeyType
            this.hashKeyValue = x.hashKeyValue
            this.operation = x.operation
            this.payload = x.payload
            this.payloadField = x.payloadField
            this.rangeKeyField = x.rangeKeyField
            this.rangeKeyType = x.rangeKeyType
            this.rangeKeyValue = x.rangeKeyValue
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.DynamoDbAction = DynamoDbAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.Payload] inside the given [block]
         */
        public fun payload(block: aws.sdk.kotlin.services.iotevents.model.Payload.Builder.() -> kotlin.Unit) {
            this.payload = aws.sdk.kotlin.services.iotevents.model.Payload.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (hashKeyField == null) hashKeyField = ""
            if (hashKeyValue == null) hashKeyValue = ""
            if (tableName == null) tableName = ""
            return this
        }
    }
}
