// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *AWS IoT SiteWise API Reference*.
 *
 * You must use expressions for all parameters in `AssetPropertyTimestamp`. The expressions accept literals, operators, functions, references, and substitution templates.
 *
 * **Examples**
 * + For literal values, the expressions must contain single quotes. For example, the value for the `timeInSeconds` parameter can be `'1586400675'`.
 * + For references, you must specify either variables or input values. For example, the value for the `offsetInNanos` parameter can be `$variable.time`.
 * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `timeInSeconds` parameter uses a substitution template.`'${$input.TemperatureInput.sensorData.timestamp / 1000}'`
 *
 * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
 */
public class AssetPropertyTimestamp private constructor(builder: Builder) {
    /**
     * The nanosecond offset converted from `timeInSeconds`. The valid range is between 0-999999999.
     */
    public val offsetInNanos: kotlin.String? = builder.offsetInNanos
    /**
     * The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
     */
    public val timeInSeconds: kotlin.String = requireNotNull(builder.timeInSeconds) { "A non-null value must be provided for timeInSeconds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetPropertyTimestamp(")
        append("offsetInNanos=$offsetInNanos,")
        append("timeInSeconds=$timeInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = offsetInNanos?.hashCode() ?: 0
        result = 31 * result + (timeInSeconds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetPropertyTimestamp

        if (offsetInNanos != other.offsetInNanos) return false
        if (timeInSeconds != other.timeInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The nanosecond offset converted from `timeInSeconds`. The valid range is between 0-999999999.
         */
        public var offsetInNanos: kotlin.String? = null
        /**
         * The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
         */
        public var timeInSeconds: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp) : this() {
            this.offsetInNanos = x.offsetInNanos
            this.timeInSeconds = x.timeInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp = AssetPropertyTimestamp(this)

        internal fun correctErrors(): Builder {
            if (timeInSeconds == null) timeInSeconds = ""
            return this
        }
    }
}
