// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the result of the analysis.
 */
public class AnalysisResult private constructor(builder: Builder) {
    /**
     * The severity level of the analysis result. Based on the severity level, analysis results fall into three general categories:
     * + `INFO` - An information result tells you about a significant field in your detector model. This type of result usually doesn't require immediate action.
     * + `WARNING` - A warning result draws special attention to fields that might cause issues for your detector model. We recommend that you review warnings and take necessary actions before you use your detector model in production environments. Otherwise, the detector model might not work as expected.
     * + `ERROR` - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.
     */
    public val level: aws.sdk.kotlin.services.iotevents.model.AnalysisResultLevel? = builder.level
    /**
     * Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.
     */
    public val locations: List<AnalysisResultLocation>? = builder.locations
    /**
     * Contains additional information about the analysis result.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:
     * + `supported-actions` - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.
     * + `service-limits` - Resources or API operations can't exceed service quotas (also known as limits). Update your detector model or request a quota increase.
     * + `structure` - The detector model must follow a structure that AWS IoT Events supports.
     * + `expression-syntax` - Your expression must follow the required syntax.
     * + `data-type` - Data types referenced in the detector model must be compatible.
     * + `referenced-data` - You must define the data referenced in your detector model before you can use the data.
     * + `referenced-resource` - Resources that the detector model uses must be available.
     *
     * For more information, see [Running detector model analyses](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html) in the *AWS IoT Events Developer Guide*.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.AnalysisResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisResult(")
        append("level=$level,")
        append("locations=$locations,")
        append("message=$message,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = level?.hashCode() ?: 0
        result = 31 * result + (locations?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalysisResult

        if (level != other.level) return false
        if (locations != other.locations) return false
        if (message != other.message) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.AnalysisResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The severity level of the analysis result. Based on the severity level, analysis results fall into three general categories:
         * + `INFO` - An information result tells you about a significant field in your detector model. This type of result usually doesn't require immediate action.
         * + `WARNING` - A warning result draws special attention to fields that might cause issues for your detector model. We recommend that you review warnings and take necessary actions before you use your detector model in production environments. Otherwise, the detector model might not work as expected.
         * + `ERROR` - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.
         */
        public var level: aws.sdk.kotlin.services.iotevents.model.AnalysisResultLevel? = null
        /**
         * Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.
         */
        public var locations: List<AnalysisResultLocation>? = null
        /**
         * Contains additional information about the analysis result.
         */
        public var message: kotlin.String? = null
        /**
         * The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:
         * + `supported-actions` - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.
         * + `service-limits` - Resources or API operations can't exceed service quotas (also known as limits). Update your detector model or request a quota increase.
         * + `structure` - The detector model must follow a structure that AWS IoT Events supports.
         * + `expression-syntax` - Your expression must follow the required syntax.
         * + `data-type` - Data types referenced in the detector model must be compatible.
         * + `referenced-data` - You must define the data referenced in your detector model before you can use the data.
         * + `referenced-resource` - Resources that the detector model uses must be available.
         *
         * For more information, see [Running detector model analyses](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html) in the *AWS IoT Events Developer Guide*.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.AnalysisResult) : this() {
            this.level = x.level
            this.locations = x.locations
            this.message = x.message
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.AnalysisResult = AnalysisResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
