// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotevents.auth.DefaultIotEventsAuthSchemeProvider
import aws.sdk.kotlin.services.iotevents.auth.IotEventsAuthSchemeProvider
import aws.sdk.kotlin.services.iotevents.endpoints.DefaultIotEventsEndpointProvider
import aws.sdk.kotlin.services.iotevents.endpoints.IotEventsEndpointParameters
import aws.sdk.kotlin.services.iotevents.endpoints.IotEventsEndpointProvider
import aws.sdk.kotlin.services.iotevents.model.CreateAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.CreateAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.CreateDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.CreateDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.CreateInputRequest
import aws.sdk.kotlin.services.iotevents.model.CreateInputResponse
import aws.sdk.kotlin.services.iotevents.model.DeleteAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.DeleteAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.DeleteDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.DeleteDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.DeleteInputRequest
import aws.sdk.kotlin.services.iotevents.model.DeleteInputResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelAnalysisRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelAnalysisResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeInputRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeInputResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeLoggingOptionsRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeLoggingOptionsResponse
import aws.sdk.kotlin.services.iotevents.model.GetDetectorModelAnalysisResultsRequest
import aws.sdk.kotlin.services.iotevents.model.GetDetectorModelAnalysisResultsResponse
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelVersionsRequest
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelVersionsResponse
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelsRequest
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelsResponse
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelVersionsRequest
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelVersionsResponse
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelsRequest
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelsResponse
import aws.sdk.kotlin.services.iotevents.model.ListInputRoutingsRequest
import aws.sdk.kotlin.services.iotevents.model.ListInputRoutingsResponse
import aws.sdk.kotlin.services.iotevents.model.ListInputsRequest
import aws.sdk.kotlin.services.iotevents.model.ListInputsResponse
import aws.sdk.kotlin.services.iotevents.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotevents.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotevents.model.PutLoggingOptionsRequest
import aws.sdk.kotlin.services.iotevents.model.PutLoggingOptionsResponse
import aws.sdk.kotlin.services.iotevents.model.StartDetectorModelAnalysisRequest
import aws.sdk.kotlin.services.iotevents.model.StartDetectorModelAnalysisResponse
import aws.sdk.kotlin.services.iotevents.model.TagResourceRequest
import aws.sdk.kotlin.services.iotevents.model.TagResourceResponse
import aws.sdk.kotlin.services.iotevents.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotevents.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotevents.model.UpdateAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.UpdateAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.UpdateDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.UpdateDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.UpdateInputRequest
import aws.sdk.kotlin.services.iotevents.model.UpdateInputResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "IoT Events"
public const val SdkVersion: String = "1.5.15"
public const val ServiceApiVersion: String = "2018-07-27"

/**
 * AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when such events occur. You can use AWS IoT Events API operations to create, read, update, and delete inputs and detector models, and to list their versions.
 */
public interface IotEventsClient : SdkClient {
    /**
     * IotEventsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotEventsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IotEvents",
                "IOT_EVENTS",
                "iot_events",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotEventsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotEventsClient = DefaultIotEventsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotEventsEndpointProvider = builder.endpointProvider ?: DefaultIotEventsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotEventsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotEventsAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoT Events"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotEventsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotEventsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *AWS IoT Events Developer Guide*.
     */
    public suspend fun createAlarmModel(input: CreateAlarmModelRequest): CreateAlarmModelResponse

    /**
     * Creates a detector model.
     */
    public suspend fun createDetectorModel(input: CreateDetectorModelRequest): CreateDetectorModelResponse

    /**
     * Creates an input.
     */
    public suspend fun createInput(input: CreateInputRequest): CreateInputResponse

    /**
     * Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can't be undone.
     */
    public suspend fun deleteAlarmModel(input: DeleteAlarmModelRequest): DeleteAlarmModelResponse

    /**
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     */
    public suspend fun deleteDetectorModel(input: DeleteDetectorModelRequest): DeleteDetectorModelResponse

    /**
     * Deletes an input.
     */
    public suspend fun deleteInput(input: DeleteInputRequest): DeleteInputResponse

    /**
     * Retrieves information about an alarm model. If you don't specify a value for the `alarmModelVersion` parameter, the latest version is returned.
     */
    public suspend fun describeAlarmModel(input: DescribeAlarmModelRequest): DescribeAlarmModelResponse

    /**
     * Describes a detector model. If the `version` parameter is not specified, information about the latest version is returned.
     */
    public suspend fun describeDetectorModel(input: DescribeDetectorModelRequest): DescribeDetectorModelResponse

    /**
     * Retrieves runtime information about a detector model analysis.
     *
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
     */
    public suspend fun describeDetectorModelAnalysis(input: DescribeDetectorModelAnalysisRequest): DescribeDetectorModelAnalysisResponse

    /**
     * Describes an input.
     */
    public suspend fun describeInput(input: DescribeInputRequest): DescribeInputResponse

    /**
     * Retrieves the current settings of the AWS IoT Events logging options.
     */
    public suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest = DescribeLoggingOptionsRequest { }): DescribeLoggingOptionsResponse

    /**
     * Retrieves one or more analysis results of the detector model.
     *
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
     */
    public suspend fun getDetectorModelAnalysisResults(input: GetDetectorModelAnalysisResultsRequest): GetDetectorModelAnalysisResultsResponse

    /**
     * Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm model version.
     */
    public suspend fun listAlarmModelVersions(input: ListAlarmModelVersionsRequest): ListAlarmModelVersionsResponse

    /**
     * Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.
     */
    public suspend fun listAlarmModels(input: ListAlarmModelsRequest = ListAlarmModelsRequest { }): ListAlarmModelsResponse

    /**
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.
     */
    public suspend fun listDetectorModelVersions(input: ListDetectorModelVersionsRequest): ListDetectorModelVersionsResponse

    /**
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     */
    public suspend fun listDetectorModels(input: ListDetectorModelsRequest = ListDetectorModelsRequest { }): ListDetectorModelsResponse

    /**
     * Lists one or more input routings.
     */
    public suspend fun listInputRoutings(input: ListInputRoutingsRequest): ListInputRoutingsResponse

    /**
     * Lists the inputs you have created.
     */
    public suspend fun listInputs(input: ListInputsRequest = ListInputsRequest { }): ListInputsResponse

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sets or updates the AWS IoT Events logging options.
     *
     * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     */
    public suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Performs an analysis of your detector model. For more information, see [Troubleshooting a detector model](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html) in the *AWS IoT Events Developer Guide*.
     */
    public suspend fun startDetectorModelAnalysis(input: StartDetectorModelAnalysisRequest): StartDetectorModelAnalysisResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the given tags (metadata) from the resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.
     */
    public suspend fun updateAlarmModel(input: UpdateAlarmModelRequest): UpdateAlarmModelResponse

    /**
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.
     */
    public suspend fun updateDetectorModel(input: UpdateDetectorModelRequest): UpdateDetectorModelResponse

    /**
     * Updates an input.
     */
    public suspend fun updateInput(input: UpdateInputRequest): UpdateInputResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotEventsClient.withConfig(block: IotEventsClient.Config.Builder.() -> Unit): IotEventsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotEventsClient(newConfig)
}

/**
 * Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *AWS IoT Events Developer Guide*.
 */
public suspend inline fun IotEventsClient.createAlarmModel(crossinline block: CreateAlarmModelRequest.Builder.() -> Unit): CreateAlarmModelResponse = createAlarmModel(CreateAlarmModelRequest.Builder().apply(block).build())

/**
 * Creates a detector model.
 */
public suspend inline fun IotEventsClient.createDetectorModel(crossinline block: CreateDetectorModelRequest.Builder.() -> Unit): CreateDetectorModelResponse = createDetectorModel(CreateDetectorModelRequest.Builder().apply(block).build())

/**
 * Creates an input.
 */
public suspend inline fun IotEventsClient.createInput(crossinline block: CreateInputRequest.Builder.() -> Unit): CreateInputResponse = createInput(CreateInputRequest.Builder().apply(block).build())

/**
 * Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can't be undone.
 */
public suspend inline fun IotEventsClient.deleteAlarmModel(crossinline block: DeleteAlarmModelRequest.Builder.() -> Unit): DeleteAlarmModelResponse = deleteAlarmModel(DeleteAlarmModelRequest.Builder().apply(block).build())

/**
 * Deletes a detector model. Any active instances of the detector model are also deleted.
 */
public suspend inline fun IotEventsClient.deleteDetectorModel(crossinline block: DeleteDetectorModelRequest.Builder.() -> Unit): DeleteDetectorModelResponse = deleteDetectorModel(DeleteDetectorModelRequest.Builder().apply(block).build())

/**
 * Deletes an input.
 */
public suspend inline fun IotEventsClient.deleteInput(crossinline block: DeleteInputRequest.Builder.() -> Unit): DeleteInputResponse = deleteInput(DeleteInputRequest.Builder().apply(block).build())

/**
 * Retrieves information about an alarm model. If you don't specify a value for the `alarmModelVersion` parameter, the latest version is returned.
 */
public suspend inline fun IotEventsClient.describeAlarmModel(crossinline block: DescribeAlarmModelRequest.Builder.() -> Unit): DescribeAlarmModelResponse = describeAlarmModel(DescribeAlarmModelRequest.Builder().apply(block).build())

/**
 * Describes a detector model. If the `version` parameter is not specified, information about the latest version is returned.
 */
public suspend inline fun IotEventsClient.describeDetectorModel(crossinline block: DescribeDetectorModelRequest.Builder.() -> Unit): DescribeDetectorModelResponse = describeDetectorModel(DescribeDetectorModelRequest.Builder().apply(block).build())

/**
 * Retrieves runtime information about a detector model analysis.
 *
 * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
 */
public suspend inline fun IotEventsClient.describeDetectorModelAnalysis(crossinline block: DescribeDetectorModelAnalysisRequest.Builder.() -> Unit): DescribeDetectorModelAnalysisResponse = describeDetectorModelAnalysis(DescribeDetectorModelAnalysisRequest.Builder().apply(block).build())

/**
 * Describes an input.
 */
public suspend inline fun IotEventsClient.describeInput(crossinline block: DescribeInputRequest.Builder.() -> Unit): DescribeInputResponse = describeInput(DescribeInputRequest.Builder().apply(block).build())

/**
 * Retrieves the current settings of the AWS IoT Events logging options.
 */
public suspend inline fun IotEventsClient.describeLoggingOptions(crossinline block: DescribeLoggingOptionsRequest.Builder.() -> Unit): DescribeLoggingOptionsResponse = describeLoggingOptions(DescribeLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Retrieves one or more analysis results of the detector model.
 *
 * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
 */
public suspend inline fun IotEventsClient.getDetectorModelAnalysisResults(crossinline block: GetDetectorModelAnalysisResultsRequest.Builder.() -> Unit): GetDetectorModelAnalysisResultsResponse = getDetectorModelAnalysisResults(GetDetectorModelAnalysisResultsRequest.Builder().apply(block).build())

/**
 * Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm model version.
 */
public suspend inline fun IotEventsClient.listAlarmModelVersions(crossinline block: ListAlarmModelVersionsRequest.Builder.() -> Unit): ListAlarmModelVersionsResponse = listAlarmModelVersions(ListAlarmModelVersionsRequest.Builder().apply(block).build())

/**
 * Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.
 */
public suspend inline fun IotEventsClient.listAlarmModels(crossinline block: ListAlarmModelsRequest.Builder.() -> Unit): ListAlarmModelsResponse = listAlarmModels(ListAlarmModelsRequest.Builder().apply(block).build())

/**
 * Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.
 */
public suspend inline fun IotEventsClient.listDetectorModelVersions(crossinline block: ListDetectorModelVersionsRequest.Builder.() -> Unit): ListDetectorModelVersionsResponse = listDetectorModelVersions(ListDetectorModelVersionsRequest.Builder().apply(block).build())

/**
 * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
 */
public suspend inline fun IotEventsClient.listDetectorModels(crossinline block: ListDetectorModelsRequest.Builder.() -> Unit): ListDetectorModelsResponse = listDetectorModels(ListDetectorModelsRequest.Builder().apply(block).build())

/**
 * Lists one or more input routings.
 */
public suspend inline fun IotEventsClient.listInputRoutings(crossinline block: ListInputRoutingsRequest.Builder.() -> Unit): ListInputRoutingsResponse = listInputRoutings(ListInputRoutingsRequest.Builder().apply(block).build())

/**
 * Lists the inputs you have created.
 */
public suspend inline fun IotEventsClient.listInputs(crossinline block: ListInputsRequest.Builder.() -> Unit): ListInputsResponse = listInputs(ListInputsRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata) you have assigned to the resource.
 */
public suspend inline fun IotEventsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sets or updates the AWS IoT Events logging options.
 *
 * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
 */
public suspend inline fun IotEventsClient.putLoggingOptions(crossinline block: PutLoggingOptionsRequest.Builder.() -> Unit): PutLoggingOptionsResponse = putLoggingOptions(PutLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Performs an analysis of your detector model. For more information, see [Troubleshooting a detector model](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html) in the *AWS IoT Events Developer Guide*.
 */
public suspend inline fun IotEventsClient.startDetectorModelAnalysis(crossinline block: StartDetectorModelAnalysisRequest.Builder.() -> Unit): StartDetectorModelAnalysisResponse = startDetectorModelAnalysis(StartDetectorModelAnalysisRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
 */
public suspend inline fun IotEventsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the given tags (metadata) from the resource.
 */
public suspend inline fun IotEventsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.
 */
public suspend inline fun IotEventsClient.updateAlarmModel(crossinline block: UpdateAlarmModelRequest.Builder.() -> Unit): UpdateAlarmModelResponse = updateAlarmModel(UpdateAlarmModelRequest.Builder().apply(block).build())

/**
 * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.
 */
public suspend inline fun IotEventsClient.updateDetectorModel(crossinline block: UpdateDetectorModelRequest.Builder.() -> Unit): UpdateDetectorModelResponse = updateDetectorModel(UpdateDetectorModelRequest.Builder().apply(block).build())

/**
 * Updates an input.
 */
public suspend inline fun IotEventsClient.updateInput(crossinline block: UpdateInputRequest.Builder.() -> Unit): UpdateInputResponse = updateInput(UpdateInputRequest.Builder().apply(block).build())
