// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotevents.model.AlarmCapabilities
import aws.sdk.kotlin.services.iotevents.model.AlarmEventActions
import aws.sdk.kotlin.services.iotevents.model.AlarmModelVersionStatus
import aws.sdk.kotlin.services.iotevents.model.AlarmNotification
import aws.sdk.kotlin.services.iotevents.model.AlarmRule
import aws.sdk.kotlin.services.iotevents.model.DescribeAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.IotEventsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeAlarmModelOperationDeserializer: HttpDeserialize<DescribeAlarmModelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeAlarmModelResponse {
        if (!response.status.isSuccess()) {
            throwDescribeAlarmModelError(context, response)
        }
        val builder = DescribeAlarmModelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAlarmModelOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeAlarmModelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotEventsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotEventsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAlarmModelOperationBody(builder: DescribeAlarmModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALARMCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmCapabilities"))
    val ALARMEVENTACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmEventActions"))
    val ALARMMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelArn"))
    val ALARMMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelDescription"))
    val ALARMMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelName"))
    val ALARMMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alarmModelVersion"))
    val ALARMNOTIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmNotification"))
    val ALARMRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("alarmRule"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("key"))
    val LASTUPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdateTime"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("severity"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMCAPABILITIES_DESCRIPTOR)
        field(ALARMEVENTACTIONS_DESCRIPTOR)
        field(ALARMMODELARN_DESCRIPTOR)
        field(ALARMMODELDESCRIPTION_DESCRIPTOR)
        field(ALARMMODELNAME_DESCRIPTOR)
        field(ALARMMODELVERSION_DESCRIPTOR)
        field(ALARMNOTIFICATION_DESCRIPTOR)
        field(ALARMRULE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(KEY_DESCRIPTOR)
        field(LASTUPDATETIME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SEVERITY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALARMCAPABILITIES_DESCRIPTOR.index -> builder.alarmCapabilities = deserializeAlarmCapabilitiesDocument(deserializer)
                ALARMEVENTACTIONS_DESCRIPTOR.index -> builder.alarmEventActions = deserializeAlarmEventActionsDocument(deserializer)
                ALARMMODELARN_DESCRIPTOR.index -> builder.alarmModelArn = deserializeString()
                ALARMMODELDESCRIPTION_DESCRIPTOR.index -> builder.alarmModelDescription = deserializeString()
                ALARMMODELNAME_DESCRIPTOR.index -> builder.alarmModelName = deserializeString()
                ALARMMODELVERSION_DESCRIPTOR.index -> builder.alarmModelVersion = deserializeString()
                ALARMNOTIFICATION_DESCRIPTOR.index -> builder.alarmNotification = deserializeAlarmNotificationDocument(deserializer)
                ALARMRULE_DESCRIPTOR.index -> builder.alarmRule = deserializeAlarmRuleDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                KEY_DESCRIPTOR.index -> builder.key = deserializeString()
                LASTUPDATETIME_DESCRIPTOR.index -> builder.lastUpdateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SEVERITY_DESCRIPTOR.index -> builder.severity = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AlarmModelVersionStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
