// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model



/**
 * Information needed to configure the payload.
 *
 * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
 */
public class Payload private constructor(builder: Builder) {
    /**
     * The content of the payload. You can use a string expression that includes quoted strings (`'<string>'`), variables (`$variable.<variable-name>`), input values (`$input.<input-name>.<path-to-datum>`), string concatenations, and quoted strings that contain `${}` as the content. The recommended maximum size of a content expression is 1 KB.
     */
    public val contentExpression: kotlin.String? = builder.contentExpression
    /**
     * The value of the payload type can be either `STRING` or `JSON`.
     */
    public val type: aws.sdk.kotlin.services.iotevents.model.PayloadType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.Payload = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Payload(")
        append("contentExpression=$contentExpression,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentExpression?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Payload

        if (contentExpression != other.contentExpression) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.Payload = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content of the payload. You can use a string expression that includes quoted strings (`'<string>'`), variables (`$variable.<variable-name>`), input values (`$input.<input-name>.<path-to-datum>`), string concatenations, and quoted strings that contain `${}` as the content. The recommended maximum size of a content expression is 1 KB.
         */
        public var contentExpression: kotlin.String? = null
        /**
         * The value of the payload type can be either `STRING` or `JSON`.
         */
        public var type: aws.sdk.kotlin.services.iotevents.model.PayloadType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.Payload) : this() {
            this.contentExpression = x.contentExpression
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.Payload = Payload(this)
    }
}
