// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model



/**
 * A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *AWS IoT SiteWise API Reference*.
 *
 * You must use expressions for all parameters in `AssetPropertyVariant`. The expressions accept literals, operators, functions, references, and substitution templates.
 *
 * **Examples**
 * + For literal values, the expressions must contain single quotes. For example, the value for the `integerValue` parameter can be `'100'`.
 * + For references, you must specify either variables or parameters. For example, the value for the `booleanValue` parameter can be `$variable.offline`.
 * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. In the following example, the value for the `doubleValue` parameter uses a substitution template. `'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`
 *
 * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
 *
 * You must specify one of the following value types, depending on the `dataType` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *AWS IoT SiteWise API Reference*.
 */
public class AssetPropertyVariant private constructor(builder: Builder) {
    /**
     * The asset property value is a Boolean value that must be `'TRUE'` or `'FALSE'`. You must use an expression, and the evaluated result should be a Boolean value.
     */
    public val booleanValue: kotlin.String? = builder.booleanValue
    /**
     * The asset property value is a double. You must use an expression, and the evaluated result should be a double.
     */
    public val doubleValue: kotlin.String? = builder.doubleValue
    /**
     * The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
     */
    public val integerValue: kotlin.String? = builder.integerValue
    /**
     * The asset property value is a string. You must use an expression, and the evaluated result should be a string.
     */
    public val stringValue: kotlin.String? = builder.stringValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetPropertyVariant(")
        append("booleanValue=$booleanValue,")
        append("doubleValue=$doubleValue,")
        append("integerValue=$integerValue,")
        append("stringValue=$stringValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = booleanValue?.hashCode() ?: 0
        result = 31 * result + (doubleValue?.hashCode() ?: 0)
        result = 31 * result + (integerValue?.hashCode() ?: 0)
        result = 31 * result + (stringValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetPropertyVariant

        if (booleanValue != other.booleanValue) return false
        if (doubleValue != other.doubleValue) return false
        if (integerValue != other.integerValue) return false
        if (stringValue != other.stringValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The asset property value is a Boolean value that must be `'TRUE'` or `'FALSE'`. You must use an expression, and the evaluated result should be a Boolean value.
         */
        public var booleanValue: kotlin.String? = null
        /**
         * The asset property value is a double. You must use an expression, and the evaluated result should be a double.
         */
        public var doubleValue: kotlin.String? = null
        /**
         * The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
         */
        public var integerValue: kotlin.String? = null
        /**
         * The asset property value is a string. You must use an expression, and the evaluated result should be a string.
         */
        public var stringValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant) : this() {
            this.booleanValue = x.booleanValue
            this.doubleValue = x.doubleValue
            this.integerValue = x.integerValue
            this.stringValue = x.stringValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant = AssetPropertyVariant(this)
    }
}
