// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.transform

import aws.sdk.kotlin.services.iotevents.model.DetectorModelDefinition
import aws.sdk.kotlin.services.iotevents.model.EvaluationMethod
import aws.sdk.kotlin.services.iotevents.model.UpdateDetectorModelRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDetectorModelOperationSerializer: HttpSerialize<UpdateDetectorModelRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateDetectorModelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "detector-models",
                "${input.detectorModelName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateDetectorModelOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDetectorModelOperationBody(context: ExecutionContext, input: UpdateDetectorModelRequest): ByteArray {
    val serializer = JsonSerializer()
    val DETECTORMODELDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("detectorModelDefinition"))
    val DETECTORMODELDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("detectorModelDescription"))
    val EVALUATIONMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("evaluationMethod"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DETECTORMODELDEFINITION_DESCRIPTOR)
        field(DETECTORMODELDESCRIPTION_DESCRIPTOR)
        field(EVALUATIONMETHOD_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.detectorModelDefinition?.let { field(DETECTORMODELDEFINITION_DESCRIPTOR, it, ::serializeDetectorModelDefinitionDocument) }
        input.detectorModelDescription?.let { field(DETECTORMODELDESCRIPTION_DESCRIPTOR, it) }
        input.evaluationMethod?.let { field(EVALUATIONMETHOD_DESCRIPTOR, it.value) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
