// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotevents.model.IotEventsException
import aws.sdk.kotlin.services.iotevents.model.StartDetectorModelAnalysisResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartDetectorModelAnalysisOperationDeserializer: HttpDeserialize<StartDetectorModelAnalysisResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartDetectorModelAnalysisResponse {
        if (!response.status.isSuccess()) {
            throwStartDetectorModelAnalysisError(context, response)
        }
        val builder = StartDetectorModelAnalysisResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartDetectorModelAnalysisOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartDetectorModelAnalysisError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotEventsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotEventsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartDetectorModelAnalysisOperationBody(builder: StartDetectorModelAnalysisResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANALYSISID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("analysisId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANALYSISID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANALYSISID_DESCRIPTOR.index -> builder.analysisId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
