// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model



/**
 * Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.
 */
public class NotificationAction private constructor(builder: Builder) {
    /**
     * Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the [AWS Lambda function provided by AWS IoT Events](https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html).
     */
    public val action: aws.sdk.kotlin.services.iotevents.model.NotificationTargetActions? = builder.action
    /**
     * Contains the configuration information of email notifications.
     */
    public val emailConfigurations: List<EmailConfiguration>? = builder.emailConfigurations
    /**
     * Contains the configuration information of SMS notifications.
     */
    public val smsConfigurations: List<SmsConfiguration>? = builder.smsConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.NotificationAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationAction(")
        append("action=$action,")
        append("emailConfigurations=$emailConfigurations,")
        append("smsConfigurations=$smsConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (emailConfigurations?.hashCode() ?: 0)
        result = 31 * result + (smsConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationAction

        if (action != other.action) return false
        if (emailConfigurations != other.emailConfigurations) return false
        if (smsConfigurations != other.smsConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.NotificationAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the [AWS Lambda function provided by AWS IoT Events](https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html).
         */
        public var action: aws.sdk.kotlin.services.iotevents.model.NotificationTargetActions? = null
        /**
         * Contains the configuration information of email notifications.
         */
        public var emailConfigurations: List<EmailConfiguration>? = null
        /**
         * Contains the configuration information of SMS notifications.
         */
        public var smsConfigurations: List<SmsConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.NotificationAction) : this() {
            this.action = x.action
            this.emailConfigurations = x.emailConfigurations
            this.smsConfigurations = x.smsConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.NotificationAction = NotificationAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.NotificationTargetActions] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.iotevents.model.NotificationTargetActions.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.iotevents.model.NotificationTargetActions.invoke(block)
        }
    }
}
