// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model



/**
 * Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
 *
 * You must use expressions for all parameters in `DynamoDBv2Action`. The expressions accept literals, operators, functions, references, and substitution templates.
 *
 * **Examples**
 * + For literal values, the expressions must contain single quotes. For example, the value for the `tableName` parameter can be `'GreenhouseTemperatureTable'`.
 * + For references, you must specify either variables or input values. For example, the value for the `tableName` parameter can be `$variable.ddbtableName`.
 * + For a substitution template, you must use `${}`, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `contentExpression` parameter in `Payload` uses a substitution template. `'{\"sensorID\": \"${$input.GreenhouseInput.sensor_id}\", \"temperature\": \"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\"}'`
 * + For a string concatenation, you must use `+`. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.In the following example, the value for the `tableName` parameter uses a string concatenation. `'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`
 *
 * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
 *
 * The value for the `type` parameter in `Payload` must be `JSON`.
 */
public class DynamoDbV2Action private constructor(builder: Builder) {
    /**
     * Information needed to configure the payload.
     *
     * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
     */
    public val payload: aws.sdk.kotlin.services.iotevents.model.Payload? = builder.payload
    /**
     * The name of the DynamoDB table.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DynamoDbV2Action(")
        append("payload=$payload,")
        append("tableName=$tableName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = payload?.hashCode() ?: 0
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DynamoDbV2Action

        if (payload != other.payload) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information needed to configure the payload.
         *
         * By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use `contentExpression`.
         */
        public var payload: aws.sdk.kotlin.services.iotevents.model.Payload? = null
        /**
         * The name of the DynamoDB table.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action) : this() {
            this.payload = x.payload
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action = DynamoDbV2Action(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.Payload] inside the given [block]
         */
        public fun payload(block: aws.sdk.kotlin.services.iotevents.model.Payload.Builder.() -> kotlin.Unit) {
            this.payload = aws.sdk.kotlin.services.iotevents.model.Payload.invoke(block)
        }
    }
}
