// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about how the detector model is configured.
 */
public class DetectorModelConfiguration private constructor(builder: Builder) {
    /**
     * The time the detector model was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The ARN of the detector model.
     */
    public val detectorModelArn: kotlin.String? = builder.detectorModelArn
    /**
     * A brief description of the detector model.
     */
    public val detectorModelDescription: kotlin.String? = builder.detectorModelDescription
    /**
     * The name of the detector model.
     */
    public val detectorModelName: kotlin.String? = builder.detectorModelName
    /**
     * The version of the detector model.
     */
    public val detectorModelVersion: kotlin.String? = builder.detectorModelVersion
    /**
     * Information about the order in which events are evaluated and how actions are executed.
     */
    public val evaluationMethod: aws.sdk.kotlin.services.iotevents.model.EvaluationMethod? = builder.evaluationMethod
    /**
     * The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information.
     *
     * This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The time the detector model was last updated.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the detector model.
     */
    public val status: aws.sdk.kotlin.services.iotevents.model.DetectorModelVersionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.DetectorModelConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectorModelConfiguration(")
        append("creationTime=$creationTime,")
        append("detectorModelArn=$detectorModelArn,")
        append("detectorModelDescription=$detectorModelDescription,")
        append("detectorModelName=$detectorModelName,")
        append("detectorModelVersion=$detectorModelVersion,")
        append("evaluationMethod=$evaluationMethod,")
        append("key=$key,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (detectorModelArn?.hashCode() ?: 0)
        result = 31 * result + (detectorModelDescription?.hashCode() ?: 0)
        result = 31 * result + (detectorModelName?.hashCode() ?: 0)
        result = 31 * result + (detectorModelVersion?.hashCode() ?: 0)
        result = 31 * result + (evaluationMethod?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectorModelConfiguration

        if (creationTime != other.creationTime) return false
        if (detectorModelArn != other.detectorModelArn) return false
        if (detectorModelDescription != other.detectorModelDescription) return false
        if (detectorModelName != other.detectorModelName) return false
        if (detectorModelVersion != other.detectorModelVersion) return false
        if (evaluationMethod != other.evaluationMethod) return false
        if (key != other.key) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.DetectorModelConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time the detector model was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the detector model.
         */
        public var detectorModelArn: kotlin.String? = null
        /**
         * A brief description of the detector model.
         */
        public var detectorModelDescription: kotlin.String? = null
        /**
         * The name of the detector model.
         */
        public var detectorModelName: kotlin.String? = null
        /**
         * The version of the detector model.
         */
        public var detectorModelVersion: kotlin.String? = null
        /**
         * Information about the order in which events are evaluated and how actions are executed.
         */
        public var evaluationMethod: aws.sdk.kotlin.services.iotevents.model.EvaluationMethod? = null
        /**
         * The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information.
         *
         * This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.
         */
        public var key: kotlin.String? = null
        /**
         * The time the detector model was last updated.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the role that grants permission to AWS IoT Events to perform its operations.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the detector model.
         */
        public var status: aws.sdk.kotlin.services.iotevents.model.DetectorModelVersionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.DetectorModelConfiguration) : this() {
            this.creationTime = x.creationTime
            this.detectorModelArn = x.detectorModelArn
            this.detectorModelDescription = x.detectorModelDescription
            this.detectorModelName = x.detectorModelName
            this.detectorModelVersion = x.detectorModelVersion
            this.evaluationMethod = x.evaluationMethod
            this.key = x.key
            this.lastUpdateTime = x.lastUpdateTime
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.DetectorModelConfiguration = DetectorModelConfiguration(this)
    }
}
