// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model



/**
 * A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *AWS IoT SiteWise API Reference*.
 *
 * You must use expressions for all parameters in `AssetPropertyValue`. The expressions accept literals, operators, functions, references, and substitution templates.
 *
 * **Examples**
 * + For literal values, the expressions must contain single quotes. For example, the value for the `quality` parameter can be `'GOOD'`.
 * + For references, you must specify either variables or input values. For example, the value for the `quality` parameter can be `$input.TemperatureInput.sensorData.quality`.
 *
 * For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *AWS IoT Events Developer Guide*.
 */
public class AssetPropertyValue private constructor(builder: Builder) {
    /**
     * The quality of the asset property value. The value must be `'GOOD'`, `'BAD'`, or `'UNCERTAIN'`.
     */
    public val quality: kotlin.String? = builder.quality
    /**
     * The timestamp associated with the asset property value. The default is the current event time.
     */
    public val timestamp: aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp? = builder.timestamp
    /**
     * The value to send to an asset property.
     */
    public val value: aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetPropertyValue(")
        append("quality=$quality,")
        append("timestamp=$timestamp,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = quality?.hashCode() ?: 0
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetPropertyValue

        if (quality != other.quality) return false
        if (timestamp != other.timestamp) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The quality of the asset property value. The value must be `'GOOD'`, `'BAD'`, or `'UNCERTAIN'`.
         */
        public var quality: kotlin.String? = null
        /**
         * The timestamp associated with the asset property value. The default is the current event time.
         */
        public var timestamp: aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp? = null
        /**
         * The value to send to an asset property.
         */
        public var value: aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue) : this() {
            this.quality = x.quality
            this.timestamp = x.timestamp
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.AssetPropertyValue = AssetPropertyValue(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp] inside the given [block]
         */
        public fun timestamp(block: aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp.Builder.() -> kotlin.Unit) {
            this.timestamp = aws.sdk.kotlin.services.iotevents.model.AssetPropertyTimestamp.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant] inside the given [block]
         */
        public fun value(block: aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant.Builder.() -> kotlin.Unit) {
            this.value = aws.sdk.kotlin.services.iotevents.model.AssetPropertyVariant.invoke(block)
        }
    }
}
