// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents.model



/**
 * An action to be performed when the `condition` is TRUE.
 */
public class Action private constructor(builder: Builder) {
    /**
     * Information needed to clear the timer.
     */
    public val clearTimer: aws.sdk.kotlin.services.iotevents.model.ClearTimerAction? = builder.clearTimer
    /**
     * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *AWS IoT Events Developer Guide*.
     */
    public val dynamoDb: aws.sdk.kotlin.services.iotevents.model.DynamoDbAction? = builder.dynamoDb
    /**
     * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *AWS IoT Events Developer Guide*.
     */
    public val dynamoDbV2: aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action? = builder.dynamoDbV2
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
     */
    public val firehose: aws.sdk.kotlin.services.iotevents.model.FirehoseAction? = builder.firehose
    /**
     * Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.
     */
    public val iotEvents: aws.sdk.kotlin.services.iotevents.model.IotEventsAction? = builder.iotEvents
    /**
     * Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .
     */
    public val iotSiteWise: aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction? = builder.iotSiteWise
    /**
     * Publishes an MQTT message with the given topic to the AWS IoT message broker.
     */
    public val iotTopicPublish: aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction? = builder.iotTopicPublish
    /**
     * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
     */
    public val lambda: aws.sdk.kotlin.services.iotevents.model.LambdaAction? = builder.lambda
    /**
     * Information needed to reset the timer.
     */
    public val resetTimer: aws.sdk.kotlin.services.iotevents.model.ResetTimerAction? = builder.resetTimer
    /**
     * Information needed to set the timer.
     */
    public val setTimer: aws.sdk.kotlin.services.iotevents.model.SetTimerAction? = builder.setTimer
    /**
     * Sets a variable to a specified value.
     */
    public val setVariable: aws.sdk.kotlin.services.iotevents.model.SetVariableAction? = builder.setVariable
    /**
     * Sends an Amazon SNS message.
     */
    public val sns: aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction? = builder.sns
    /**
     * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
     */
    public val sqs: aws.sdk.kotlin.services.iotevents.model.SqsAction? = builder.sqs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotevents.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("clearTimer=$clearTimer,")
        append("dynamoDb=$dynamoDb,")
        append("dynamoDbV2=$dynamoDbV2,")
        append("firehose=$firehose,")
        append("iotEvents=$iotEvents,")
        append("iotSiteWise=$iotSiteWise,")
        append("iotTopicPublish=$iotTopicPublish,")
        append("lambda=$lambda,")
        append("resetTimer=$resetTimer,")
        append("setTimer=$setTimer,")
        append("setVariable=$setVariable,")
        append("sns=$sns,")
        append("sqs=$sqs)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clearTimer?.hashCode() ?: 0
        result = 31 * result + (dynamoDb?.hashCode() ?: 0)
        result = 31 * result + (dynamoDbV2?.hashCode() ?: 0)
        result = 31 * result + (firehose?.hashCode() ?: 0)
        result = 31 * result + (iotEvents?.hashCode() ?: 0)
        result = 31 * result + (iotSiteWise?.hashCode() ?: 0)
        result = 31 * result + (iotTopicPublish?.hashCode() ?: 0)
        result = 31 * result + (lambda?.hashCode() ?: 0)
        result = 31 * result + (resetTimer?.hashCode() ?: 0)
        result = 31 * result + (setTimer?.hashCode() ?: 0)
        result = 31 * result + (setVariable?.hashCode() ?: 0)
        result = 31 * result + (sns?.hashCode() ?: 0)
        result = 31 * result + (sqs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (clearTimer != other.clearTimer) return false
        if (dynamoDb != other.dynamoDb) return false
        if (dynamoDbV2 != other.dynamoDbV2) return false
        if (firehose != other.firehose) return false
        if (iotEvents != other.iotEvents) return false
        if (iotSiteWise != other.iotSiteWise) return false
        if (iotTopicPublish != other.iotTopicPublish) return false
        if (lambda != other.lambda) return false
        if (resetTimer != other.resetTimer) return false
        if (setTimer != other.setTimer) return false
        if (setVariable != other.setVariable) return false
        if (sns != other.sns) return false
        if (sqs != other.sqs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotevents.model.Action = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information needed to clear the timer.
         */
        public var clearTimer: aws.sdk.kotlin.services.iotevents.model.ClearTimerAction? = null
        /**
         * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *AWS IoT Events Developer Guide*.
         */
        public var dynamoDb: aws.sdk.kotlin.services.iotevents.model.DynamoDbAction? = null
        /**
         * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *AWS IoT Events Developer Guide*.
         */
        public var dynamoDbV2: aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action? = null
        /**
         * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
         */
        public var firehose: aws.sdk.kotlin.services.iotevents.model.FirehoseAction? = null
        /**
         * Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.
         */
        public var iotEvents: aws.sdk.kotlin.services.iotevents.model.IotEventsAction? = null
        /**
         * Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .
         */
        public var iotSiteWise: aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction? = null
        /**
         * Publishes an MQTT message with the given topic to the AWS IoT message broker.
         */
        public var iotTopicPublish: aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction? = null
        /**
         * Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
         */
        public var lambda: aws.sdk.kotlin.services.iotevents.model.LambdaAction? = null
        /**
         * Information needed to reset the timer.
         */
        public var resetTimer: aws.sdk.kotlin.services.iotevents.model.ResetTimerAction? = null
        /**
         * Information needed to set the timer.
         */
        public var setTimer: aws.sdk.kotlin.services.iotevents.model.SetTimerAction? = null
        /**
         * Sets a variable to a specified value.
         */
        public var setVariable: aws.sdk.kotlin.services.iotevents.model.SetVariableAction? = null
        /**
         * Sends an Amazon SNS message.
         */
        public var sns: aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction? = null
        /**
         * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
         */
        public var sqs: aws.sdk.kotlin.services.iotevents.model.SqsAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotevents.model.Action) : this() {
            this.clearTimer = x.clearTimer
            this.dynamoDb = x.dynamoDb
            this.dynamoDbV2 = x.dynamoDbV2
            this.firehose = x.firehose
            this.iotEvents = x.iotEvents
            this.iotSiteWise = x.iotSiteWise
            this.iotTopicPublish = x.iotTopicPublish
            this.lambda = x.lambda
            this.resetTimer = x.resetTimer
            this.setTimer = x.setTimer
            this.setVariable = x.setVariable
            this.sns = x.sns
            this.sqs = x.sqs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotevents.model.Action = Action(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.ClearTimerAction] inside the given [block]
         */
        public fun clearTimer(block: aws.sdk.kotlin.services.iotevents.model.ClearTimerAction.Builder.() -> kotlin.Unit) {
            this.clearTimer = aws.sdk.kotlin.services.iotevents.model.ClearTimerAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.DynamoDbAction] inside the given [block]
         */
        public fun dynamoDb(block: aws.sdk.kotlin.services.iotevents.model.DynamoDbAction.Builder.() -> kotlin.Unit) {
            this.dynamoDb = aws.sdk.kotlin.services.iotevents.model.DynamoDbAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action] inside the given [block]
         */
        public fun dynamoDbV2(block: aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action.Builder.() -> kotlin.Unit) {
            this.dynamoDbV2 = aws.sdk.kotlin.services.iotevents.model.DynamoDbV2Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.FirehoseAction] inside the given [block]
         */
        public fun firehose(block: aws.sdk.kotlin.services.iotevents.model.FirehoseAction.Builder.() -> kotlin.Unit) {
            this.firehose = aws.sdk.kotlin.services.iotevents.model.FirehoseAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.IotEventsAction] inside the given [block]
         */
        public fun iotEvents(block: aws.sdk.kotlin.services.iotevents.model.IotEventsAction.Builder.() -> kotlin.Unit) {
            this.iotEvents = aws.sdk.kotlin.services.iotevents.model.IotEventsAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction] inside the given [block]
         */
        public fun iotSiteWise(block: aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction.Builder.() -> kotlin.Unit) {
            this.iotSiteWise = aws.sdk.kotlin.services.iotevents.model.IotSiteWiseAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction] inside the given [block]
         */
        public fun iotTopicPublish(block: aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction.Builder.() -> kotlin.Unit) {
            this.iotTopicPublish = aws.sdk.kotlin.services.iotevents.model.IotTopicPublishAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.LambdaAction] inside the given [block]
         */
        public fun lambda(block: aws.sdk.kotlin.services.iotevents.model.LambdaAction.Builder.() -> kotlin.Unit) {
            this.lambda = aws.sdk.kotlin.services.iotevents.model.LambdaAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.ResetTimerAction] inside the given [block]
         */
        public fun resetTimer(block: aws.sdk.kotlin.services.iotevents.model.ResetTimerAction.Builder.() -> kotlin.Unit) {
            this.resetTimer = aws.sdk.kotlin.services.iotevents.model.ResetTimerAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.SetTimerAction] inside the given [block]
         */
        public fun setTimer(block: aws.sdk.kotlin.services.iotevents.model.SetTimerAction.Builder.() -> kotlin.Unit) {
            this.setTimer = aws.sdk.kotlin.services.iotevents.model.SetTimerAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.SetVariableAction] inside the given [block]
         */
        public fun setVariable(block: aws.sdk.kotlin.services.iotevents.model.SetVariableAction.Builder.() -> kotlin.Unit) {
            this.setVariable = aws.sdk.kotlin.services.iotevents.model.SetVariableAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction] inside the given [block]
         */
        public fun sns(block: aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction.Builder.() -> kotlin.Unit) {
            this.sns = aws.sdk.kotlin.services.iotevents.model.SnsTopicPublishAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotevents.model.SqsAction] inside the given [block]
         */
        public fun sqs(block: aws.sdk.kotlin.services.iotevents.model.SqsAction.Builder.() -> kotlin.Unit) {
            this.sqs = aws.sdk.kotlin.services.iotevents.model.SqsAction.invoke(block)
        }
    }
}
