// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotevents.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotevents.model.*
import aws.sdk.kotlin.services.iotevents.model.CreateAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.CreateAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.CreateDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.CreateDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.CreateInputRequest
import aws.sdk.kotlin.services.iotevents.model.CreateInputResponse
import aws.sdk.kotlin.services.iotevents.model.DeleteAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.DeleteAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.DeleteDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.DeleteDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.DeleteInputRequest
import aws.sdk.kotlin.services.iotevents.model.DeleteInputResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelAnalysisRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelAnalysisResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeInputRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeInputResponse
import aws.sdk.kotlin.services.iotevents.model.DescribeLoggingOptionsRequest
import aws.sdk.kotlin.services.iotevents.model.DescribeLoggingOptionsResponse
import aws.sdk.kotlin.services.iotevents.model.GetDetectorModelAnalysisResultsRequest
import aws.sdk.kotlin.services.iotevents.model.GetDetectorModelAnalysisResultsResponse
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelVersionsRequest
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelVersionsResponse
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelsRequest
import aws.sdk.kotlin.services.iotevents.model.ListAlarmModelsResponse
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelVersionsRequest
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelVersionsResponse
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelsRequest
import aws.sdk.kotlin.services.iotevents.model.ListDetectorModelsResponse
import aws.sdk.kotlin.services.iotevents.model.ListInputRoutingsRequest
import aws.sdk.kotlin.services.iotevents.model.ListInputRoutingsResponse
import aws.sdk.kotlin.services.iotevents.model.ListInputsRequest
import aws.sdk.kotlin.services.iotevents.model.ListInputsResponse
import aws.sdk.kotlin.services.iotevents.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotevents.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotevents.model.PutLoggingOptionsRequest
import aws.sdk.kotlin.services.iotevents.model.PutLoggingOptionsResponse
import aws.sdk.kotlin.services.iotevents.model.StartDetectorModelAnalysisRequest
import aws.sdk.kotlin.services.iotevents.model.StartDetectorModelAnalysisResponse
import aws.sdk.kotlin.services.iotevents.model.TagResourceRequest
import aws.sdk.kotlin.services.iotevents.model.TagResourceResponse
import aws.sdk.kotlin.services.iotevents.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotevents.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotevents.model.UpdateAlarmModelRequest
import aws.sdk.kotlin.services.iotevents.model.UpdateAlarmModelResponse
import aws.sdk.kotlin.services.iotevents.model.UpdateDetectorModelRequest
import aws.sdk.kotlin.services.iotevents.model.UpdateDetectorModelResponse
import aws.sdk.kotlin.services.iotevents.model.UpdateInputRequest
import aws.sdk.kotlin.services.iotevents.model.UpdateInputResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when such events occur. You can use AWS IoT Events API operations to create, read, update, and delete inputs and detector models, and to list their versions.
 */
public interface IotEventsClient : SdkClient {

    override val serviceName: String
        get() = "IoT Events"
    /**
     * IotEventsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IotEventsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIotEventsClient(config)
        }

        public operator fun invoke(config: Config): IotEventsClient = DefaultIotEventsClient(config)

        /**
         * Construct a [IotEventsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IotEventsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIotEventsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *AWS IoT Events Developer Guide*.
     */
    public suspend fun createAlarmModel(input: CreateAlarmModelRequest): CreateAlarmModelResponse

    /**
     * Creates a detector model.
     */
    public suspend fun createDetectorModel(input: CreateDetectorModelRequest): CreateDetectorModelResponse

    /**
     * Creates an input.
     */
    public suspend fun createInput(input: CreateInputRequest): CreateInputResponse

    /**
     * Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can't be undone.
     */
    public suspend fun deleteAlarmModel(input: DeleteAlarmModelRequest): DeleteAlarmModelResponse

    /**
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     */
    public suspend fun deleteDetectorModel(input: DeleteDetectorModelRequest): DeleteDetectorModelResponse

    /**
     * Deletes an input.
     */
    public suspend fun deleteInput(input: DeleteInputRequest): DeleteInputResponse

    /**
     * Retrieves information about an alarm model. If you don't specify a value for the `alarmModelVersion` parameter, the latest version is returned.
     */
    public suspend fun describeAlarmModel(input: DescribeAlarmModelRequest): DescribeAlarmModelResponse

    /**
     * Describes a detector model. If the `version` parameter is not specified, information about the latest version is returned.
     */
    public suspend fun describeDetectorModel(input: DescribeDetectorModelRequest): DescribeDetectorModelResponse

    /**
     * Retrieves runtime information about a detector model analysis.
     *
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
     */
    public suspend fun describeDetectorModelAnalysis(input: DescribeDetectorModelAnalysisRequest): DescribeDetectorModelAnalysisResponse

    /**
     * Describes an input.
     */
    public suspend fun describeInput(input: DescribeInputRequest): DescribeInputResponse

    /**
     * Retrieves the current settings of the AWS IoT Events logging options.
     */
    public suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest = DescribeLoggingOptionsRequest {}): DescribeLoggingOptionsResponse

    /**
     * Retrieves one or more analysis results of the detector model.
     *
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
     */
    public suspend fun getDetectorModelAnalysisResults(input: GetDetectorModelAnalysisResultsRequest): GetDetectorModelAnalysisResultsResponse

    /**
     * Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm model version.
     */
    public suspend fun listAlarmModelVersions(input: ListAlarmModelVersionsRequest): ListAlarmModelVersionsResponse

    /**
     * Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.
     */
    public suspend fun listAlarmModels(input: ListAlarmModelsRequest = ListAlarmModelsRequest {}): ListAlarmModelsResponse

    /**
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.
     */
    public suspend fun listDetectorModelVersions(input: ListDetectorModelVersionsRequest): ListDetectorModelVersionsResponse

    /**
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     */
    public suspend fun listDetectorModels(input: ListDetectorModelsRequest = ListDetectorModelsRequest {}): ListDetectorModelsResponse

    /**
     * Lists one or more input routings.
     */
    public suspend fun listInputRoutings(input: ListInputRoutingsRequest): ListInputRoutingsResponse

    /**
     * Lists the inputs you have created.
     */
    public suspend fun listInputs(input: ListInputsRequest = ListInputsRequest {}): ListInputsResponse

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sets or updates the AWS IoT Events logging options.
     *
     * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     */
    public suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Performs an analysis of your detector model. For more information, see [Troubleshooting a detector model](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html) in the *AWS IoT Events Developer Guide*.
     */
    public suspend fun startDetectorModelAnalysis(input: StartDetectorModelAnalysisRequest): StartDetectorModelAnalysisResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the given tags (metadata) from the resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.
     */
    public suspend fun updateAlarmModel(input: UpdateAlarmModelRequest): UpdateAlarmModelResponse

    /**
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.
     */
    public suspend fun updateDetectorModel(input: UpdateDetectorModelRequest): UpdateDetectorModelResponse

    /**
     * Updates an input.
     */
    public suspend fun updateInput(input: UpdateInputRequest): UpdateInputResponse
}

/**
 * Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *AWS IoT Events Developer Guide*.
 */
public suspend inline fun IotEventsClient.createAlarmModel(crossinline block: CreateAlarmModelRequest.Builder.() -> Unit): CreateAlarmModelResponse = createAlarmModel(CreateAlarmModelRequest.Builder().apply(block).build())

/**
 * Creates a detector model.
 */
public suspend inline fun IotEventsClient.createDetectorModel(crossinline block: CreateDetectorModelRequest.Builder.() -> Unit): CreateDetectorModelResponse = createDetectorModel(CreateDetectorModelRequest.Builder().apply(block).build())

/**
 * Creates an input.
 */
public suspend inline fun IotEventsClient.createInput(crossinline block: CreateInputRequest.Builder.() -> Unit): CreateInputResponse = createInput(CreateInputRequest.Builder().apply(block).build())

/**
 * Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can't be undone.
 */
public suspend inline fun IotEventsClient.deleteAlarmModel(crossinline block: DeleteAlarmModelRequest.Builder.() -> Unit): DeleteAlarmModelResponse = deleteAlarmModel(DeleteAlarmModelRequest.Builder().apply(block).build())

/**
 * Deletes a detector model. Any active instances of the detector model are also deleted.
 */
public suspend inline fun IotEventsClient.deleteDetectorModel(crossinline block: DeleteDetectorModelRequest.Builder.() -> Unit): DeleteDetectorModelResponse = deleteDetectorModel(DeleteDetectorModelRequest.Builder().apply(block).build())

/**
 * Deletes an input.
 */
public suspend inline fun IotEventsClient.deleteInput(crossinline block: DeleteInputRequest.Builder.() -> Unit): DeleteInputResponse = deleteInput(DeleteInputRequest.Builder().apply(block).build())

/**
 * Retrieves information about an alarm model. If you don't specify a value for the `alarmModelVersion` parameter, the latest version is returned.
 */
public suspend inline fun IotEventsClient.describeAlarmModel(crossinline block: DescribeAlarmModelRequest.Builder.() -> Unit): DescribeAlarmModelResponse = describeAlarmModel(DescribeAlarmModelRequest.Builder().apply(block).build())

/**
 * Describes a detector model. If the `version` parameter is not specified, information about the latest version is returned.
 */
public suspend inline fun IotEventsClient.describeDetectorModel(crossinline block: DescribeDetectorModelRequest.Builder.() -> Unit): DescribeDetectorModelResponse = describeDetectorModel(DescribeDetectorModelRequest.Builder().apply(block).build())

/**
 * Retrieves runtime information about a detector model analysis.
 *
 * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
 */
public suspend inline fun IotEventsClient.describeDetectorModelAnalysis(crossinline block: DescribeDetectorModelAnalysisRequest.Builder.() -> Unit): DescribeDetectorModelAnalysisResponse = describeDetectorModelAnalysis(DescribeDetectorModelAnalysisRequest.Builder().apply(block).build())

/**
 * Describes an input.
 */
public suspend inline fun IotEventsClient.describeInput(crossinline block: DescribeInputRequest.Builder.() -> Unit): DescribeInputResponse = describeInput(DescribeInputRequest.Builder().apply(block).build())

/**
 * Retrieves the current settings of the AWS IoT Events logging options.
 */
public suspend inline fun IotEventsClient.describeLoggingOptions(crossinline block: DescribeLoggingOptionsRequest.Builder.() -> Unit): DescribeLoggingOptionsResponse = describeLoggingOptions(DescribeLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Retrieves one or more analysis results of the detector model.
 *
 * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
 */
public suspend inline fun IotEventsClient.getDetectorModelAnalysisResults(crossinline block: GetDetectorModelAnalysisResultsRequest.Builder.() -> Unit): GetDetectorModelAnalysisResultsResponse = getDetectorModelAnalysisResults(GetDetectorModelAnalysisResultsRequest.Builder().apply(block).build())

/**
 * Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm model version.
 */
public suspend inline fun IotEventsClient.listAlarmModelVersions(crossinline block: ListAlarmModelVersionsRequest.Builder.() -> Unit): ListAlarmModelVersionsResponse = listAlarmModelVersions(ListAlarmModelVersionsRequest.Builder().apply(block).build())

/**
 * Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.
 */
public suspend inline fun IotEventsClient.listAlarmModels(crossinline block: ListAlarmModelsRequest.Builder.() -> Unit): ListAlarmModelsResponse = listAlarmModels(ListAlarmModelsRequest.Builder().apply(block).build())

/**
 * Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.
 */
public suspend inline fun IotEventsClient.listDetectorModelVersions(crossinline block: ListDetectorModelVersionsRequest.Builder.() -> Unit): ListDetectorModelVersionsResponse = listDetectorModelVersions(ListDetectorModelVersionsRequest.Builder().apply(block).build())

/**
 * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
 */
public suspend inline fun IotEventsClient.listDetectorModels(crossinline block: ListDetectorModelsRequest.Builder.() -> Unit): ListDetectorModelsResponse = listDetectorModels(ListDetectorModelsRequest.Builder().apply(block).build())

/**
 * Lists one or more input routings.
 */
public suspend inline fun IotEventsClient.listInputRoutings(crossinline block: ListInputRoutingsRequest.Builder.() -> Unit): ListInputRoutingsResponse = listInputRoutings(ListInputRoutingsRequest.Builder().apply(block).build())

/**
 * Lists the inputs you have created.
 */
public suspend inline fun IotEventsClient.listInputs(crossinline block: ListInputsRequest.Builder.() -> Unit): ListInputsResponse = listInputs(ListInputsRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata) you have assigned to the resource.
 */
public suspend inline fun IotEventsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sets or updates the AWS IoT Events logging options.
 *
 * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
 */
public suspend inline fun IotEventsClient.putLoggingOptions(crossinline block: PutLoggingOptionsRequest.Builder.() -> Unit): PutLoggingOptionsResponse = putLoggingOptions(PutLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Performs an analysis of your detector model. For more information, see [Troubleshooting a detector model](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html) in the *AWS IoT Events Developer Guide*.
 */
public suspend inline fun IotEventsClient.startDetectorModelAnalysis(crossinline block: StartDetectorModelAnalysisRequest.Builder.() -> Unit): StartDetectorModelAnalysisResponse = startDetectorModelAnalysis(StartDetectorModelAnalysisRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
 */
public suspend inline fun IotEventsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the given tags (metadata) from the resource.
 */
public suspend inline fun IotEventsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.
 */
public suspend inline fun IotEventsClient.updateAlarmModel(crossinline block: UpdateAlarmModelRequest.Builder.() -> Unit): UpdateAlarmModelResponse = updateAlarmModel(UpdateAlarmModelRequest.Builder().apply(block).build())

/**
 * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.
 */
public suspend inline fun IotEventsClient.updateDetectorModel(crossinline block: UpdateDetectorModelRequest.Builder.() -> Unit): UpdateDetectorModelResponse = updateDetectorModel(UpdateDetectorModelRequest.Builder().apply(block).build())

/**
 * Updates an input.
 */
public suspend inline fun IotEventsClient.updateInput(crossinline block: UpdateInputRequest.Builder.() -> Unit): UpdateInputResponse = updateInput(UpdateInputRequest.Builder().apply(block).build())
