// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotevents

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iotevents.model.*
import aws.sdk.kotlin.services.iotevents.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "IoT Events"
public const val ServiceApiVersion: String = "2018-07-27"
public const val SdkVersion: String = "0.17.11-beta"

internal class DefaultIotEventsClient(override val config: IotEventsClient.Config) : IotEventsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *AWS IoT Events Developer Guide*.
     */
    override suspend fun createAlarmModel(input: CreateAlarmModelRequest): CreateAlarmModelResponse {
        val op = SdkHttpOperation.build<CreateAlarmModelRequest, CreateAlarmModelResponse> {
            serializer = CreateAlarmModelOperationSerializer()
            deserializer = CreateAlarmModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAlarmModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a detector model.
     */
    override suspend fun createDetectorModel(input: CreateDetectorModelRequest): CreateDetectorModelResponse {
        val op = SdkHttpOperation.build<CreateDetectorModelRequest, CreateDetectorModelResponse> {
            serializer = CreateDetectorModelOperationSerializer()
            deserializer = CreateDetectorModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDetectorModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an input.
     */
    override suspend fun createInput(input: CreateInputRequest): CreateInputResponse {
        val op = SdkHttpOperation.build<CreateInputRequest, CreateInputResponse> {
            serializer = CreateInputOperationSerializer()
            deserializer = CreateInputOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can't be undone.
     */
    override suspend fun deleteAlarmModel(input: DeleteAlarmModelRequest): DeleteAlarmModelResponse {
        val op = SdkHttpOperation.build<DeleteAlarmModelRequest, DeleteAlarmModelResponse> {
            serializer = DeleteAlarmModelOperationSerializer()
            deserializer = DeleteAlarmModelOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAlarmModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a detector model. Any active instances of the detector model are also deleted.
     */
    override suspend fun deleteDetectorModel(input: DeleteDetectorModelRequest): DeleteDetectorModelResponse {
        val op = SdkHttpOperation.build<DeleteDetectorModelRequest, DeleteDetectorModelResponse> {
            serializer = DeleteDetectorModelOperationSerializer()
            deserializer = DeleteDetectorModelOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDetectorModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an input.
     */
    override suspend fun deleteInput(input: DeleteInputRequest): DeleteInputResponse {
        val op = SdkHttpOperation.build<DeleteInputRequest, DeleteInputResponse> {
            serializer = DeleteInputOperationSerializer()
            deserializer = DeleteInputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an alarm model. If you don't specify a value for the `alarmModelVersion` parameter, the latest version is returned.
     */
    override suspend fun describeAlarmModel(input: DescribeAlarmModelRequest): DescribeAlarmModelResponse {
        val op = SdkHttpOperation.build<DescribeAlarmModelRequest, DescribeAlarmModelResponse> {
            serializer = DescribeAlarmModelOperationSerializer()
            deserializer = DescribeAlarmModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAlarmModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a detector model. If the `version` parameter is not specified, information about the latest version is returned.
     */
    override suspend fun describeDetectorModel(input: DescribeDetectorModelRequest): DescribeDetectorModelResponse {
        val op = SdkHttpOperation.build<DescribeDetectorModelRequest, DescribeDetectorModelResponse> {
            serializer = DescribeDetectorModelOperationSerializer()
            deserializer = DescribeDetectorModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDetectorModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves runtime information about a detector model analysis.
     *
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
     */
    override suspend fun describeDetectorModelAnalysis(input: DescribeDetectorModelAnalysisRequest): DescribeDetectorModelAnalysisResponse {
        val op = SdkHttpOperation.build<DescribeDetectorModelAnalysisRequest, DescribeDetectorModelAnalysisResponse> {
            serializer = DescribeDetectorModelAnalysisOperationSerializer()
            deserializer = DescribeDetectorModelAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDetectorModelAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an input.
     */
    override suspend fun describeInput(input: DescribeInputRequest): DescribeInputResponse {
        val op = SdkHttpOperation.build<DescribeInputRequest, DescribeInputResponse> {
            serializer = DescribeInputOperationSerializer()
            deserializer = DescribeInputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current settings of the AWS IoT Events logging options.
     */
    override suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest): DescribeLoggingOptionsResponse {
        val op = SdkHttpOperation.build<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResponse> {
            serializer = DescribeLoggingOptionsOperationSerializer()
            deserializer = DescribeLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves one or more analysis results of the detector model.
     *
     * After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.
     */
    override suspend fun getDetectorModelAnalysisResults(input: GetDetectorModelAnalysisResultsRequest): GetDetectorModelAnalysisResultsResponse {
        val op = SdkHttpOperation.build<GetDetectorModelAnalysisResultsRequest, GetDetectorModelAnalysisResultsResponse> {
            serializer = GetDetectorModelAnalysisResultsOperationSerializer()
            deserializer = GetDetectorModelAnalysisResultsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDetectorModelAnalysisResults"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm model version.
     */
    override suspend fun listAlarmModelVersions(input: ListAlarmModelVersionsRequest): ListAlarmModelVersionsResponse {
        val op = SdkHttpOperation.build<ListAlarmModelVersionsRequest, ListAlarmModelVersionsResponse> {
            serializer = ListAlarmModelVersionsOperationSerializer()
            deserializer = ListAlarmModelVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAlarmModelVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.
     */
    override suspend fun listAlarmModels(input: ListAlarmModelsRequest): ListAlarmModelsResponse {
        val op = SdkHttpOperation.build<ListAlarmModelsRequest, ListAlarmModelsResponse> {
            serializer = ListAlarmModelsOperationSerializer()
            deserializer = ListAlarmModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAlarmModels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.
     */
    override suspend fun listDetectorModelVersions(input: ListDetectorModelVersionsRequest): ListDetectorModelVersionsResponse {
        val op = SdkHttpOperation.build<ListDetectorModelVersionsRequest, ListDetectorModelVersionsResponse> {
            serializer = ListDetectorModelVersionsOperationSerializer()
            deserializer = ListDetectorModelVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDetectorModelVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the detector models you have created. Only the metadata associated with each detector model is returned.
     */
    override suspend fun listDetectorModels(input: ListDetectorModelsRequest): ListDetectorModelsResponse {
        val op = SdkHttpOperation.build<ListDetectorModelsRequest, ListDetectorModelsResponse> {
            serializer = ListDetectorModelsOperationSerializer()
            deserializer = ListDetectorModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDetectorModels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists one or more input routings.
     */
    override suspend fun listInputRoutings(input: ListInputRoutingsRequest): ListInputRoutingsResponse {
        val op = SdkHttpOperation.build<ListInputRoutingsRequest, ListInputRoutingsResponse> {
            serializer = ListInputRoutingsOperationSerializer()
            deserializer = ListInputRoutingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInputRoutings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the inputs you have created.
     */
    override suspend fun listInputs(input: ListInputsRequest): ListInputsResponse {
        val op = SdkHttpOperation.build<ListInputsRequest, ListInputsResponse> {
            serializer = ListInputsOperationSerializer()
            deserializer = ListInputsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInputs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets or updates the AWS IoT Events logging options.
     *
     * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     */
    override suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse {
        val op = SdkHttpOperation.build<PutLoggingOptionsRequest, PutLoggingOptionsResponse> {
            serializer = PutLoggingOptionsOperationSerializer()
            deserializer = PutLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutLoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Performs an analysis of your detector model. For more information, see [Troubleshooting a detector model](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html) in the *AWS IoT Events Developer Guide*.
     */
    override suspend fun startDetectorModelAnalysis(input: StartDetectorModelAnalysisRequest): StartDetectorModelAnalysisResponse {
        val op = SdkHttpOperation.build<StartDetectorModelAnalysisRequest, StartDetectorModelAnalysisResponse> {
            serializer = StartDetectorModelAnalysisOperationSerializer()
            deserializer = StartDetectorModelAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDetectorModelAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the given tags (metadata) from the resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.
     */
    override suspend fun updateAlarmModel(input: UpdateAlarmModelRequest): UpdateAlarmModelResponse {
        val op = SdkHttpOperation.build<UpdateAlarmModelRequest, UpdateAlarmModelResponse> {
            serializer = UpdateAlarmModelOperationSerializer()
            deserializer = UpdateAlarmModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAlarmModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.
     */
    override suspend fun updateDetectorModel(input: UpdateDetectorModelRequest): UpdateDetectorModelResponse {
        val op = SdkHttpOperation.build<UpdateDetectorModelRequest, UpdateDetectorModelResponse> {
            serializer = UpdateDetectorModelOperationSerializer()
            deserializer = UpdateDetectorModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDetectorModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an input.
     */
    override suspend fun updateInput(input: UpdateInputRequest): UpdateInputResponse {
        val op = SdkHttpOperation.build<UpdateInputRequest, UpdateInputResponse> {
            serializer = UpdateInputOperationSerializer()
            deserializer = UpdateInputOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInput"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotevents"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotevents")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
