// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotdeviceadvisor.model.IotDeviceAdvisorException
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateSuiteDefinitionOperationDeserializer: HttpDeserialize<UpdateSuiteDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSuiteDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSuiteDefinitionError(context, response)
        }
        val builder = UpdateSuiteDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSuiteDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateSuiteDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotDeviceAdvisorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotDeviceAdvisorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSuiteDefinitionOperationBody(builder: UpdateSuiteDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val SUITEDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionArn"))
    val SUITEDEFINITIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionId"))
    val SUITEDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionName"))
    val SUITEDEFINITIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(SUITEDEFINITIONARN_DESCRIPTOR)
        field(SUITEDEFINITIONID_DESCRIPTOR)
        field(SUITEDEFINITIONNAME_DESCRIPTOR)
        field(SUITEDEFINITIONVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                SUITEDEFINITIONARN_DESCRIPTOR.index -> builder.suiteDefinitionArn = deserializeString()
                SUITEDEFINITIONID_DESCRIPTOR.index -> builder.suiteDefinitionId = deserializeString()
                SUITEDEFINITIONNAME_DESCRIPTOR.index -> builder.suiteDefinitionName = deserializeString()
                SUITEDEFINITIONVERSION_DESCRIPTOR.index -> builder.suiteDefinitionVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
