// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor.serde

import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.IotDeviceAdvisorException
import aws.sdk.kotlin.services.iotdeviceadvisor.model.SuiteRunConfiguration
import aws.sdk.kotlin.services.iotdeviceadvisor.model.SuiteRunStatus
import aws.sdk.kotlin.services.iotdeviceadvisor.model.TestResult
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableMapOf


internal class GetSuiteRunOperationDeserializer: HttpDeserializer.NonStreaming<GetSuiteRunResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSuiteRunResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSuiteRunError(context, call, payload)
        }
        val builder = GetSuiteRunResponse.Builder()

        if (payload != null) {
            deserializeGetSuiteRunOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSuiteRunError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotDeviceAdvisorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotDeviceAdvisorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSuiteRunOperationBody(builder: GetSuiteRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ERRORREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorReason"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUITEDEFINITIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionId"))
    val SUITEDEFINITIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionVersion"))
    val SUITERUNARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteRunArn"))
    val SUITERUNCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("suiteRunConfiguration"))
    val SUITERUNID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteRunId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TESTRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("testResult"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(ERRORREASON_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUITEDEFINITIONID_DESCRIPTOR)
        field(SUITEDEFINITIONVERSION_DESCRIPTOR)
        field(SUITERUNARN_DESCRIPTOR)
        field(SUITERUNCONFIGURATION_DESCRIPTOR)
        field(SUITERUNID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TESTRESULT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ERRORREASON_DESCRIPTOR.index -> builder.errorReason = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SuiteRunStatus.fromValue(it) }
                SUITEDEFINITIONID_DESCRIPTOR.index -> builder.suiteDefinitionId = deserializeString()
                SUITEDEFINITIONVERSION_DESCRIPTOR.index -> builder.suiteDefinitionVersion = deserializeString()
                SUITERUNARN_DESCRIPTOR.index -> builder.suiteRunArn = deserializeString()
                SUITERUNCONFIGURATION_DESCRIPTOR.index -> builder.suiteRunConfiguration = deserializeSuiteRunConfigurationDocument(deserializer)
                SUITERUNID_DESCRIPTOR.index -> builder.suiteRunId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TESTRESULT_DESCRIPTOR.index -> builder.testResult = deserializeTestResultDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
