// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.iotdeviceadvisor.auth.DefaultIotDeviceAdvisorAuthSchemeProvider
import aws.sdk.kotlin.services.iotdeviceadvisor.auth.IotDeviceAdvisorAuthSchemeProvider
import aws.sdk.kotlin.services.iotdeviceadvisor.endpoints.DefaultIotDeviceAdvisorEndpointProvider
import aws.sdk.kotlin.services.iotdeviceadvisor.endpoints.IotDeviceAdvisorEndpointParameters
import aws.sdk.kotlin.services.iotdeviceadvisor.endpoints.IotDeviceAdvisorEndpointProvider
import aws.sdk.kotlin.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetEndpointRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetEndpointResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunReportRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunReportResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteRunsRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteRunsResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StartSuiteRunRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StartSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StopSuiteRunRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StopSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.TagResourceRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.TagResourceResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IotDeviceAdvisor"
public const val SdkVersion: String = "1.0.69"
public const val ServiceApiVersion: String = "2020-09-18"

/**
 * Amazon Web Services IoT Core Device Advisor is a cloud-based, fully managed test capability for validating IoT devices during device software development. Device Advisor provides pre-built tests that you can use to validate IoT devices for reliable and secure connectivity with Amazon Web Services IoT Core before deploying devices to production. By using Device Advisor, you can confirm that your devices can connect to Amazon Web Services IoT Core, follow security best practices and, if applicable, receive software updates from IoT Device Management. You can also download signed qualification reports to submit to the Amazon Web Services Partner Network to get your device qualified for the Amazon Web Services Partner Device Catalog without the need to send your device in and wait for it to be tested.
 */
public interface IotDeviceAdvisorClient : SdkClient {
    /**
     * IotDeviceAdvisorClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotDeviceAdvisorClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IotDeviceAdvisor",
                "IOTDEVICEADVISOR",
                "iotdeviceadvisor",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotDeviceAdvisorClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotDeviceAdvisorClient = DefaultIotDeviceAdvisorClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotDeviceAdvisorEndpointProvider = builder.endpointProvider ?: DefaultIotDeviceAdvisorEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotDeviceAdvisorAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotDeviceAdvisorAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IotDeviceAdvisor"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotDeviceAdvisorEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotDeviceAdvisorAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Device Advisor test suite.
     *
     * Requires permission to access the [CreateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createSuiteDefinition(input: CreateSuiteDefinitionRequest): CreateSuiteDefinitionResponse

    /**
     * Deletes a Device Advisor test suite.
     *
     * Requires permission to access the [DeleteSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteSuiteDefinition(input: DeleteSuiteDefinitionRequest): DeleteSuiteDefinitionResponse

    /**
     * Gets information about an Device Advisor endpoint.
     */
    public suspend fun getEndpoint(input: GetEndpointRequest = GetEndpointRequest { }): GetEndpointResponse

    /**
     * Gets information about a Device Advisor test suite.
     *
     * Requires permission to access the [GetSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getSuiteDefinition(input: GetSuiteDefinitionRequest): GetSuiteDefinitionResponse

    /**
     * Gets information about a Device Advisor test suite run.
     *
     * Requires permission to access the [GetSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getSuiteRun(input: GetSuiteRunRequest): GetSuiteRunResponse

    /**
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     *
     * Requires permission to access the [GetSuiteRunReport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getSuiteRunReport(input: GetSuiteRunReportRequest): GetSuiteRunReportResponse

    /**
     * Lists the Device Advisor test suites you have created.
     *
     * Requires permission to access the [ListSuiteDefinitions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listSuiteDefinitions(input: ListSuiteDefinitionsRequest = ListSuiteDefinitionsRequest { }): ListSuiteDefinitionsResponse

    /**
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.
     *
     * Requires permission to access the [ListSuiteRuns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listSuiteRuns(input: ListSuiteRunsRequest = ListSuiteRunsRequest { }): ListSuiteRunsResponse

    /**
     * Lists the tags attached to an IoT Device Advisor resource.
     *
     * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a Device Advisor test suite run.
     *
     * Requires permission to access the [StartSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun startSuiteRun(input: StartSuiteRunRequest): StartSuiteRunResponse

    /**
     * Stops a Device Advisor test suite run that is currently running.
     *
     * Requires permission to access the [StopSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun stopSuiteRun(input: StopSuiteRunRequest): StopSuiteRunResponse

    /**
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     *
     * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an IoT Device Advisor resource.
     *
     * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a Device Advisor test suite.
     *
     * Requires permission to access the [UpdateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateSuiteDefinition(input: UpdateSuiteDefinitionRequest): UpdateSuiteDefinitionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotDeviceAdvisorClient.withConfig(block: IotDeviceAdvisorClient.Config.Builder.() -> Unit): IotDeviceAdvisorClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotDeviceAdvisorClient(newConfig)
}

/**
 * Creates a Device Advisor test suite.
 *
 * Requires permission to access the [CreateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.createSuiteDefinition(crossinline block: CreateSuiteDefinitionRequest.Builder.() -> Unit): CreateSuiteDefinitionResponse = createSuiteDefinition(CreateSuiteDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a Device Advisor test suite.
 *
 * Requires permission to access the [DeleteSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.deleteSuiteDefinition(crossinline block: DeleteSuiteDefinitionRequest.Builder.() -> Unit): DeleteSuiteDefinitionResponse = deleteSuiteDefinition(DeleteSuiteDefinitionRequest.Builder().apply(block).build())

/**
 * Gets information about an Device Advisor endpoint.
 */
public suspend inline fun IotDeviceAdvisorClient.getEndpoint(crossinline block: GetEndpointRequest.Builder.() -> Unit): GetEndpointResponse = getEndpoint(GetEndpointRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Advisor test suite.
 *
 * Requires permission to access the [GetSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.getSuiteDefinition(crossinline block: GetSuiteDefinitionRequest.Builder.() -> Unit): GetSuiteDefinitionResponse = getSuiteDefinition(GetSuiteDefinitionRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Advisor test suite run.
 *
 * Requires permission to access the [GetSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.getSuiteRun(crossinline block: GetSuiteRunRequest.Builder.() -> Unit): GetSuiteRunResponse = getSuiteRun(GetSuiteRunRequest.Builder().apply(block).build())

/**
 * Gets a report download link for a successful Device Advisor qualifying test suite run.
 *
 * Requires permission to access the [GetSuiteRunReport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.getSuiteRunReport(crossinline block: GetSuiteRunReportRequest.Builder.() -> Unit): GetSuiteRunReportResponse = getSuiteRunReport(GetSuiteRunReportRequest.Builder().apply(block).build())

/**
 * Lists the Device Advisor test suites you have created.
 *
 * Requires permission to access the [ListSuiteDefinitions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.listSuiteDefinitions(crossinline block: ListSuiteDefinitionsRequest.Builder.() -> Unit): ListSuiteDefinitionsResponse = listSuiteDefinitions(ListSuiteDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.
 *
 * Requires permission to access the [ListSuiteRuns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.listSuiteRuns(crossinline block: ListSuiteRunsRequest.Builder.() -> Unit): ListSuiteRunsResponse = listSuiteRuns(ListSuiteRunsRequest.Builder().apply(block).build())

/**
 * Lists the tags attached to an IoT Device Advisor resource.
 *
 * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a Device Advisor test suite run.
 *
 * Requires permission to access the [StartSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.startSuiteRun(crossinline block: StartSuiteRunRequest.Builder.() -> Unit): StartSuiteRunResponse = startSuiteRun(StartSuiteRunRequest.Builder().apply(block).build())

/**
 * Stops a Device Advisor test suite run that is currently running.
 *
 * Requires permission to access the [StopSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.stopSuiteRun(crossinline block: StopSuiteRunRequest.Builder.() -> Unit): StopSuiteRunResponse = stopSuiteRun(StopSuiteRunRequest.Builder().apply(block).build())

/**
 * Adds to and modifies existing tags of an IoT Device Advisor resource.
 *
 * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an IoT Device Advisor resource.
 *
 * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a Device Advisor test suite.
 *
 * Requires permission to access the [UpdateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.updateSuiteDefinition(crossinline block: UpdateSuiteDefinitionRequest.Builder.() -> Unit): UpdateSuiteDefinitionResponse = updateSuiteDefinition(UpdateSuiteDefinitionRequest.Builder().apply(block).build())
