// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotdeviceadvisor.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotdeviceadvisor.model.*
import aws.sdk.kotlin.services.iotdeviceadvisor.model.CreateSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.DeleteSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.DeleteSuiteDefinitionResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetEndpointRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetEndpointResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteDefinitionResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunReportRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunReportResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteRunsRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteRunsResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StartSuiteRunRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StartSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StopSuiteRunRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.StopSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.TagResourceRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.TagResourceResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UpdateSuiteDefinitionRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.UpdateSuiteDefinitionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services IoT Core Device Advisor is a cloud-based, fully managed test capability for validating IoT devices during device software development. Device Advisor provides pre-built tests that you can use to validate IoT devices for reliable and secure connectivity with Amazon Web Services IoT Core before deploying devices to production. By using Device Advisor, you can confirm that your devices can connect to Amazon Web Services IoT Core, follow security best practices and, if applicable, receive software updates from IoT Device Management. You can also download signed qualification reports to submit to the Amazon Web Services Partner Network to get your device qualified for the Amazon Web Services Partner Device Catalog without the need to send your device in and wait for it to be tested.
 */
public interface IotDeviceAdvisorClient : SdkClient {

    override val serviceName: String
        get() = "IotDeviceAdvisor"
    /**
     * IotDeviceAdvisorClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IotDeviceAdvisorClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIotDeviceAdvisorClient(config)
        }

        public operator fun invoke(config: Config): IotDeviceAdvisorClient = DefaultIotDeviceAdvisorClient(config)

        /**
         * Construct a [IotDeviceAdvisorClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IotDeviceAdvisorClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIotDeviceAdvisorClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Device Advisor test suite.
     *
     * Requires permission to access the [CreateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun createSuiteDefinition(input: CreateSuiteDefinitionRequest = CreateSuiteDefinitionRequest {}): CreateSuiteDefinitionResponse

    /**
     * Deletes a Device Advisor test suite.
     *
     * Requires permission to access the [DeleteSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun deleteSuiteDefinition(input: DeleteSuiteDefinitionRequest): DeleteSuiteDefinitionResponse

    /**
     * Gets information about an Device Advisor endpoint.
     */
    public suspend fun getEndpoint(input: GetEndpointRequest = GetEndpointRequest {}): GetEndpointResponse

    /**
     * Gets information about a Device Advisor test suite.
     *
     * Requires permission to access the [GetSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getSuiteDefinition(input: GetSuiteDefinitionRequest): GetSuiteDefinitionResponse

    /**
     * Gets information about a Device Advisor test suite run.
     *
     * Requires permission to access the [GetSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getSuiteRun(input: GetSuiteRunRequest): GetSuiteRunResponse

    /**
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     *
     * Requires permission to access the [GetSuiteRunReport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun getSuiteRunReport(input: GetSuiteRunReportRequest): GetSuiteRunReportResponse

    /**
     * Lists the Device Advisor test suites you have created.
     *
     * Requires permission to access the [ListSuiteDefinitions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listSuiteDefinitions(input: ListSuiteDefinitionsRequest = ListSuiteDefinitionsRequest {}): ListSuiteDefinitionsResponse

    /**
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.
     *
     * Requires permission to access the [ListSuiteRuns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listSuiteRuns(input: ListSuiteRunsRequest = ListSuiteRunsRequest {}): ListSuiteRunsResponse

    /**
     * Lists the tags attached to an IoT Device Advisor resource.
     *
     * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a Device Advisor test suite run.
     *
     * Requires permission to access the [StartSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun startSuiteRun(input: StartSuiteRunRequest): StartSuiteRunResponse

    /**
     * Stops a Device Advisor test suite run that is currently running.
     *
     * Requires permission to access the [StopSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun stopSuiteRun(input: StopSuiteRunRequest): StopSuiteRunResponse

    /**
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     *
     * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an IoT Device Advisor resource.
     *
     * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a Device Advisor test suite.
     *
     * Requires permission to access the [UpdateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun updateSuiteDefinition(input: UpdateSuiteDefinitionRequest): UpdateSuiteDefinitionResponse
}

/**
 * Creates a Device Advisor test suite.
 *
 * Requires permission to access the [CreateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.createSuiteDefinition(crossinline block: CreateSuiteDefinitionRequest.Builder.() -> Unit): CreateSuiteDefinitionResponse = createSuiteDefinition(CreateSuiteDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a Device Advisor test suite.
 *
 * Requires permission to access the [DeleteSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.deleteSuiteDefinition(crossinline block: DeleteSuiteDefinitionRequest.Builder.() -> Unit): DeleteSuiteDefinitionResponse = deleteSuiteDefinition(DeleteSuiteDefinitionRequest.Builder().apply(block).build())

/**
 * Gets information about an Device Advisor endpoint.
 */
public suspend inline fun IotDeviceAdvisorClient.getEndpoint(crossinline block: GetEndpointRequest.Builder.() -> Unit): GetEndpointResponse = getEndpoint(GetEndpointRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Advisor test suite.
 *
 * Requires permission to access the [GetSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.getSuiteDefinition(crossinline block: GetSuiteDefinitionRequest.Builder.() -> Unit): GetSuiteDefinitionResponse = getSuiteDefinition(GetSuiteDefinitionRequest.Builder().apply(block).build())

/**
 * Gets information about a Device Advisor test suite run.
 *
 * Requires permission to access the [GetSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.getSuiteRun(crossinline block: GetSuiteRunRequest.Builder.() -> Unit): GetSuiteRunResponse = getSuiteRun(GetSuiteRunRequest.Builder().apply(block).build())

/**
 * Gets a report download link for a successful Device Advisor qualifying test suite run.
 *
 * Requires permission to access the [GetSuiteRunReport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.getSuiteRunReport(crossinline block: GetSuiteRunReportRequest.Builder.() -> Unit): GetSuiteRunReportResponse = getSuiteRunReport(GetSuiteRunReportRequest.Builder().apply(block).build())

/**
 * Lists the Device Advisor test suites you have created.
 *
 * Requires permission to access the [ListSuiteDefinitions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.listSuiteDefinitions(crossinline block: ListSuiteDefinitionsRequest.Builder.() -> Unit): ListSuiteDefinitionsResponse = listSuiteDefinitions(ListSuiteDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.
 *
 * Requires permission to access the [ListSuiteRuns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.listSuiteRuns(crossinline block: ListSuiteRunsRequest.Builder.() -> Unit): ListSuiteRunsResponse = listSuiteRuns(ListSuiteRunsRequest.Builder().apply(block).build())

/**
 * Lists the tags attached to an IoT Device Advisor resource.
 *
 * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a Device Advisor test suite run.
 *
 * Requires permission to access the [StartSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.startSuiteRun(crossinline block: StartSuiteRunRequest.Builder.() -> Unit): StartSuiteRunResponse = startSuiteRun(StartSuiteRunRequest.Builder().apply(block).build())

/**
 * Stops a Device Advisor test suite run that is currently running.
 *
 * Requires permission to access the [StopSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.stopSuiteRun(crossinline block: StopSuiteRunRequest.Builder.() -> Unit): StopSuiteRunResponse = stopSuiteRun(StopSuiteRunRequest.Builder().apply(block).build())

/**
 * Adds to and modifies existing tags of an IoT Device Advisor resource.
 *
 * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an IoT Device Advisor resource.
 *
 * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a Device Advisor test suite.
 *
 * Requires permission to access the [UpdateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IotDeviceAdvisorClient.updateSuiteDefinition(crossinline block: UpdateSuiteDefinitionRequest.Builder.() -> Unit): UpdateSuiteDefinitionResponse = updateSuiteDefinition(UpdateSuiteDefinitionRequest.Builder().apply(block).build())
