// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input for the Publish operation.
 */
public class PublishRequest private constructor(builder: Builder) {
    /**
     * A UTF-8 encoded string that describes the content of the publishing message.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The base64-encoded binary data used by the sender of the request message to identify which request the response message is for when it's received. `correlationData` is an HTTP header value in the API.
     */
    public val correlationData: kotlin.String? = builder.correlationData
    /**
     * A user-defined integer value that represents the message expiry interval in seconds. If absent, the message doesn't expire. For more information about the limits of `messageExpiry`, see [Amazon Web Services IoT Core message broker and protocol limits and quotas ](https://docs.aws.amazon.com/general/latest/gr/iot-core.html#message-broker-limits) from the Amazon Web Services Reference Guide.
     */
    public val messageExpiry: kotlin.Long? = builder.messageExpiry
    /**
     * The message body. MQTT accepts text, binary, and empty (null) message payloads.
     *
     * Publishing an empty (null) payload with **retain** = `true` deletes the retained message identified by **topic** from Amazon Web Services IoT Core.
     */
    public val payload: kotlin.ByteArray? = builder.payload
    /**
     * An `Enum` string value that indicates whether the payload is formatted as UTF-8. `payloadFormatIndicator` is an HTTP header value in the API.
     */
    public val payloadFormatIndicator: aws.sdk.kotlin.services.iotdataplane.model.PayloadFormatIndicator? = builder.payloadFormatIndicator
    /**
     * The Quality of Service (QoS) level. The default QoS level is 0.
     */
    public val qos: kotlin.Int? = builder.qos
    /**
     * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to describe the topic which the receiver should publish to as part of the request-response flow. The topic must not contain wildcard characters.
     */
    public val responseTopic: kotlin.String? = builder.responseTopic
    /**
     * A Boolean value that determines whether to set the RETAIN flag when the message is published.
     *
     * Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
     *
     * Valid values: `true` | `false`
     *
     * Default value: `false`
     */
    public val retain: kotlin.Boolean? = builder.retain
    /**
     * The name of the MQTT topic.
     */
    public val topic: kotlin.String? = builder.topic
    /**
     * A JSON string that contains an array of JSON objects. If you don’t use Amazon Web Services SDK or CLI, you must encode the JSON string to base64 format before adding it to the HTTP header. `userProperties` is an HTTP header value in the API.
     *
     * The following example `userProperties` parameter is a JSON string which represents two User Properties. Note that it needs to be base64-encoded:
     *
     * `[{"deviceName": "alpha"}, {"deviceCnt": "45"}]`
     */
    public val userProperties: kotlin.String? = builder.userProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotdataplane.model.PublishRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublishRequest(")
        append("contentType=$contentType,")
        append("correlationData=$correlationData,")
        append("messageExpiry=$messageExpiry,")
        append("payload=$payload,")
        append("payloadFormatIndicator=$payloadFormatIndicator,")
        append("qos=$qos,")
        append("responseTopic=$responseTopic,")
        append("retain=$retain,")
        append("topic=$topic,")
        append("userProperties=$userProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (correlationData?.hashCode() ?: 0)
        result = 31 * result + (messageExpiry?.hashCode() ?: 0)
        result = 31 * result + (payload?.contentHashCode() ?: 0)
        result = 31 * result + (payloadFormatIndicator?.hashCode() ?: 0)
        result = 31 * result + (qos ?: 0)
        result = 31 * result + (responseTopic?.hashCode() ?: 0)
        result = 31 * result + (retain?.hashCode() ?: 0)
        result = 31 * result + (topic?.hashCode() ?: 0)
        result = 31 * result + (userProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublishRequest

        if (contentType != other.contentType) return false
        if (correlationData != other.correlationData) return false
        if (messageExpiry != other.messageExpiry) return false
        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false
        if (payloadFormatIndicator != other.payloadFormatIndicator) return false
        if (qos != other.qos) return false
        if (responseTopic != other.responseTopic) return false
        if (retain != other.retain) return false
        if (topic != other.topic) return false
        if (userProperties != other.userProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotdataplane.model.PublishRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A UTF-8 encoded string that describes the content of the publishing message.
         */
        public var contentType: kotlin.String? = null
        /**
         * The base64-encoded binary data used by the sender of the request message to identify which request the response message is for when it's received. `correlationData` is an HTTP header value in the API.
         */
        public var correlationData: kotlin.String? = null
        /**
         * A user-defined integer value that represents the message expiry interval in seconds. If absent, the message doesn't expire. For more information about the limits of `messageExpiry`, see [Amazon Web Services IoT Core message broker and protocol limits and quotas ](https://docs.aws.amazon.com/general/latest/gr/iot-core.html#message-broker-limits) from the Amazon Web Services Reference Guide.
         */
        public var messageExpiry: kotlin.Long? = null
        /**
         * The message body. MQTT accepts text, binary, and empty (null) message payloads.
         *
         * Publishing an empty (null) payload with **retain** = `true` deletes the retained message identified by **topic** from Amazon Web Services IoT Core.
         */
        public var payload: kotlin.ByteArray? = null
        /**
         * An `Enum` string value that indicates whether the payload is formatted as UTF-8. `payloadFormatIndicator` is an HTTP header value in the API.
         */
        public var payloadFormatIndicator: aws.sdk.kotlin.services.iotdataplane.model.PayloadFormatIndicator? = null
        /**
         * The Quality of Service (QoS) level. The default QoS level is 0.
         */
        public var qos: kotlin.Int? = null
        /**
         * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to describe the topic which the receiver should publish to as part of the request-response flow. The topic must not contain wildcard characters.
         */
        public var responseTopic: kotlin.String? = null
        /**
         * A Boolean value that determines whether to set the RETAIN flag when the message is published.
         *
         * Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
         *
         * Valid values: `true` | `false`
         *
         * Default value: `false`
         */
        public var retain: kotlin.Boolean? = null
        /**
         * The name of the MQTT topic.
         */
        public var topic: kotlin.String? = null
        /**
         * A JSON string that contains an array of JSON objects. If you don’t use Amazon Web Services SDK or CLI, you must encode the JSON string to base64 format before adding it to the HTTP header. `userProperties` is an HTTP header value in the API.
         *
         * The following example `userProperties` parameter is a JSON string which represents two User Properties. Note that it needs to be base64-encoded:
         *
         * `[{"deviceName": "alpha"}, {"deviceCnt": "45"}]`
         */
        public var userProperties: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotdataplane.model.PublishRequest) : this() {
            this.contentType = x.contentType
            this.correlationData = x.correlationData
            this.messageExpiry = x.messageExpiry
            this.payload = x.payload
            this.payloadFormatIndicator = x.payloadFormatIndicator
            this.qos = x.qos
            this.responseTopic = x.responseTopic
            this.retain = x.retain
            this.topic = x.topic
            this.userProperties = x.userProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotdataplane.model.PublishRequest = PublishRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
