// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.serde

import aws.sdk.kotlin.services.iotdataplane.model.GetRetainedMessageResponse
import aws.sdk.kotlin.services.iotdataplane.model.IotDataPlaneException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRetainedMessageOperationDeserializer: HttpDeserializer.NonStreaming<GetRetainedMessageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRetainedMessageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRetainedMessageError(context, call, payload)
        }
        val builder = GetRetainedMessageResponse.Builder()

        if (payload != null) {
            deserializeGetRetainedMessageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRetainedMessageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotDataPlaneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MethodNotAllowedException" -> MethodNotAllowedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotDataPlaneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRetainedMessageOperationBody(builder: GetRetainedMessageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("lastModifiedTime"))
    val PAYLOAD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("payload"))
    val QOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("qos"))
    val TOPIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("topic"))
    val USERPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("userProperties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(PAYLOAD_DESCRIPTOR)
        field(QOS_DESCRIPTOR)
        field(TOPIC_DESCRIPTOR)
        field(USERPROPERTIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeLong()
                PAYLOAD_DESCRIPTOR.index -> builder.payload = deserializeByteArray()
                QOS_DESCRIPTOR.index -> builder.qos = deserializeInt()
                TOPIC_DESCRIPTOR.index -> builder.topic = deserializeString()
                USERPROPERTIES_DESCRIPTOR.index -> builder.userProperties = deserializeByteArray()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
