// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.serde

import aws.sdk.kotlin.services.iotdataplane.model.PayloadFormatIndicator
import aws.sdk.kotlin.services.iotdataplane.model.PublishRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.text.encoding.encodeBase64


internal class PublishOperationSerializer: HttpSerializer.NonStreaming<PublishRequest> {
    override fun serialize(context: ExecutionContext, input: PublishRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.topic) { "topic is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("topics"))
                add(PercentEncoding.SmithyLabel.encode(input.topic))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.contentType != null) add("contentType", input.contentType)
                if (input.messageExpiry != null) add("messageExpiry", input.messageExpiry.toString())
                if (input.qos != null) add("qos", input.qos.toString())
                if (input.responseTopic != null) add("responseTopic", input.responseTopic)
                if (input.retain != null) add("retain", input.retain.toString())
            }
        }

        builder.headers {
            if (input.correlationData != null) append("x-amz-mqtt5-correlation-data", input.correlationData)
            if (input.payloadFormatIndicator != null) append("x-amz-mqtt5-payload-format-indicator", input.payloadFormatIndicator.value)
            if (input.userProperties != null) append("x-amz-mqtt5-user-properties", input.userProperties.encodeBase64())
        }

        if (input.payload != null) {
            builder.body = HttpBody.fromBytes(input.payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.payload == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
