// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.paginators

import aws.sdk.kotlin.services.iotdataplane.IotDataPlaneClient
import aws.sdk.kotlin.services.iotdataplane.model.ListRetainedMessagesRequest
import aws.sdk.kotlin.services.iotdataplane.model.ListRetainedMessagesResponse
import aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListRetainedMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRetainedMessagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRetainedMessagesResponse]
 */
public fun IotDataPlaneClient.listRetainedMessagesPaginated(initialRequest: ListRetainedMessagesRequest = ListRetainedMessagesRequest { }): Flow<ListRetainedMessagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRetainedMessagesPaginated.listRetainedMessages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRetainedMessagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRetainedMessagesResponse]
 */
public fun IotDataPlaneClient.listRetainedMessagesPaginated(block: ListRetainedMessagesRequest.Builder.() -> Unit): Flow<ListRetainedMessagesResponse> =
    listRetainedMessagesPaginated(ListRetainedMessagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRetainedMessagesPaginated]
 * to access the nested member [RetainedMessageSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RetainedMessageSummary]
 */
@JvmName("listRetainedMessagesResponseRetainedMessageSummary")
public fun Flow<ListRetainedMessagesResponse>.retainedTopics(): Flow<RetainedMessageSummary> =
    transform() { response ->
        response.retainedTopics?.forEach {
            emit(it)
        }
    }
