// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a single retained message.
 */
public class RetainedMessageSummary private constructor(builder: Builder) {
    /**
     * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
     */
    public val lastModifiedTime: kotlin.Long = builder.lastModifiedTime
    /**
     * The size of the retained message's payload in bytes.
     */
    public val payloadSize: kotlin.Long = builder.payloadSize
    /**
     * The quality of service (QoS) level used to publish the retained message.
     */
    public val qos: kotlin.Int = builder.qos
    /**
     * The topic name to which the retained message was published.
     */
    public val topic: kotlin.String? = builder.topic

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetainedMessageSummary(")
        append("lastModifiedTime=$lastModifiedTime,")
        append("payloadSize=$payloadSize,")
        append("qos=$qos,")
        append("topic=$topic")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastModifiedTime.hashCode()
        result = 31 * result + (payloadSize.hashCode())
        result = 31 * result + (qos)
        result = 31 * result + (topic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetainedMessageSummary

        if (lastModifiedTime != other.lastModifiedTime) return false
        if (payloadSize != other.payloadSize) return false
        if (qos != other.qos) return false
        if (topic != other.topic) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
         */
        public var lastModifiedTime: kotlin.Long = 0L
        /**
         * The size of the retained message's payload in bytes.
         */
        public var payloadSize: kotlin.Long = 0L
        /**
         * The quality of service (QoS) level used to publish the retained message.
         */
        public var qos: kotlin.Int = 0
        /**
         * The topic name to which the retained message was published.
         */
        public var topic: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary) : this() {
            this.lastModifiedTime = x.lastModifiedTime
            this.payloadSize = x.payloadSize
            this.qos = x.qos
            this.topic = x.topic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary = RetainedMessageSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
