/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.iotdataplane.endpoints;

import aws.sdk.kotlin.runtime.endpoint.functions.PartitionConfig;
import aws.sdk.kotlin.services.iotdataplane.endpoints.IotDataPlaneEndpointParameters;
import aws.sdk.kotlin.services.iotdataplane.endpoints.IotDataPlaneEndpointProvider;
import aws.sdk.kotlin.services.iotdataplane.endpoints.internal.PartitionsKt;
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint;
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException;
import aws.smithy.kotlin.runtime.net.url.Url;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Laws/sdk/kotlin/services/iotdataplane/endpoints/DefaultIotDataPlaneEndpointProvider;", "Laws/sdk/kotlin/services/iotdataplane/endpoints/IotDataPlaneEndpointProvider;", "()V", "resolveEndpoint", "Laws/smithy/kotlin/runtime/client/endpoints/Endpoint;", "params", "Laws/sdk/kotlin/services/iotdataplane/endpoints/IotDataPlaneEndpointParameters;", "(Laws/sdk/kotlin/services/iotdataplane/endpoints/IotDataPlaneEndpointParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "iotdataplane"})
public final class DefaultIotDataPlaneEndpointProvider
implements IotDataPlaneEndpointProvider {
    @Nullable
    public Object resolveEndpoint(@NotNull IotDataPlaneEndpointParameters params, @NotNull Continuation<? super Endpoint> $completion) {
        if (params.getEndpoint() != null) {
            if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)params.getEndpoint(), null, (int)2, null), null, 2, null);
        }
        if (params.getRegion() != null) {
            DefaultIotDataPlaneEndpointProvider $this$resolveEndpoint_u24lambda_u240 = this;
            boolean bl = false;
            PartitionConfig partitionResult = PartitionsKt.partition(params.getRegion());
            if (partitionResult != null) {
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsFIPS()) && Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://data-ats.iot-fips." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both");
                }
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)partitionResult.getSupportsFIPS(), (Object)Boxing.boxBoolean((boolean)true))) {
                        if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"ca-central-1")) {
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.iot-fips.ca-central-1.amazonaws.com", null, (int)2, null), null, 2, null);
                        }
                        if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"us-east-1")) {
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.iot-fips.us-east-1.amazonaws.com", null, (int)2, null), null, 2, null);
                        }
                        if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"us-east-2")) {
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.iot-fips.us-east-2.amazonaws.com", null, (int)2, null), null, 2, null);
                        }
                        if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"us-west-1")) {
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.iot-fips.us-west-1.amazonaws.com", null, (int)2, null), null, 2, null);
                        }
                        if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"us-west-2")) {
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.iot-fips.us-west-2.amazonaws.com", null, (int)2, null), null, 2, null);
                        }
                        if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"us-gov-east-1")) {
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.iot-fips.us-gov-east-1.amazonaws.com", null, (int)2, null), null, 2, null);
                        }
                        if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"us-gov-west-1")) {
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.iot-fips.us-gov-west-1.amazonaws.com", null, (int)2, null), null, 2, null);
                        }
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://data-ats.iot-fips." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS is enabled but this partition does not support FIPS");
                }
                if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://data-ats.iot." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("DualStack is enabled but this partition does not support DualStack");
                }
                if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"cn-north-1")) {
                    return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://data.ats.iot.cn-north-1.amazonaws.com.cn", null, (int)2, null), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)"aws", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://data-ats.iot." + params.getRegion() + ".amazonaws.com"), null, (int)2, null), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)"aws-cn", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://data-ats.iot." + params.getRegion() + ".amazonaws.com.cn"), null, (int)2, null), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)"aws-us-gov", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://data-ats.iot." + params.getRegion() + ".amazonaws.com"), null, (int)2, null), null, 2, null);
                }
                return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://data-ats.iot." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
            }
        }
        throw new EndpointProviderException("Invalid Configuration: Missing Region");
    }
}

