// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.serde

import aws.sdk.kotlin.services.iotdataplane.model.UpdateThingShadowRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateThingShadowOperationSerializer: HttpSerialize<UpdateThingShadowRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateThingShadowRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.thingName) { "thingName is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "things",
                "${input.thingName}".encodeLabel(),
                "shadow",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.shadowName != null) append("name", input.shadowName)
            }
        }

        if (input.payload != null) {
            builder.body = HttpBody.fromBytes(input.payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.payload == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
