// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.serde

import aws.sdk.kotlin.services.iotdataplane.model.PayloadFormatIndicator
import aws.sdk.kotlin.services.iotdataplane.model.PublishRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.util.encodeBase64


internal class PublishOperationSerializer: HttpSerialize<PublishRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PublishRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.topic) { "topic is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "topics",
                "${input.topic}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.contentType != null) append("contentType", input.contentType)
                if (input.messageExpiry != null) append("messageExpiry", "${input.messageExpiry}")
                if (input.qos != null) append("qos", "${input.qos}")
                if (input.responseTopic != null) append("responseTopic", input.responseTopic)
                if (input.retain != null) append("retain", "${input.retain}")
            }
        }

        builder.headers {
            if (input.correlationData?.isNotEmpty() == true) append("x-amz-mqtt5-correlation-data", input.correlationData)
            if (input.payloadFormatIndicator != null) append("x-amz-mqtt5-payload-format-indicator", input.payloadFormatIndicator.value)
            if (input.userProperties?.isNotEmpty() == true) append("x-amz-mqtt5-user-properties", input.userProperties.encodeBase64())
        }

        if (input.payload != null) {
            builder.body = HttpBody.fromBytes(input.payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.payload == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
