// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.endpoints

import aws.sdk.kotlin.services.iotdataplane.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultIotDataPlaneEndpointProvider: IotDataPlaneEndpointProvider {
    public override suspend fun resolveEndpoint(params: IotDataPlaneEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint, UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://data-ats.iot-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            if (
                                params.region == "ca-central-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://data.iot-fips.ca-central-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            if (
                                params.region == "us-east-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://data.iot-fips.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            if (
                                params.region == "us-east-2"
                            ) {
                                return Endpoint(
                                    Url.parse("https://data.iot-fips.us-east-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            if (
                                params.region == "us-west-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://data.iot-fips.us-west-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            if (
                                params.region == "us-west-2"
                            ) {
                                return Endpoint(
                                    Url.parse("https://data.iot-fips.us-west-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            if (
                                params.region == "us-gov-east-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://data.iot-fips.us-gov-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            if (
                                params.region == "us-gov-west-1"
                            ) {
                                return Endpoint(
                                    Url.parse("https://data.iot-fips.us-gov-west-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                                )
                            }
                            return Endpoint(
                                Url.parse("https://data-ats.iot-fips.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://data-ats.iot.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    if (
                        params.region == "cn-north-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://data.ats.iot.cn-north-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    if (
                        "aws" == partitionResult?.name
                    ) {
                        return Endpoint(
                            Url.parse("https://data-ats.iot.${params.region}.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    if (
                        "aws-cn" == partitionResult?.name
                    ) {
                        return Endpoint(
                            Url.parse("https://data-ats.iot.${params.region}.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    if (
                        "aws-us-gov" == partitionResult?.name
                    ) {
                        return Endpoint(
                            Url.parse("https://data-ats.iot.${params.region}.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                        )
                    }
                    return Endpoint(
                        Url.parse("https://data-ats.iot.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
