// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotanalytics.model.IoTAnalyticsException
import aws.sdk.kotlin.services.iotanalytics.model.SampleChannelDataResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes


internal class SampleChannelDataOperationDeserializer: HttpDeserialize<SampleChannelDataResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SampleChannelDataResponse {
        if (!response.status.isSuccess()) {
            throwSampleChannelDataError(context, response)
        }
        val builder = SampleChannelDataResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSampleChannelDataOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeSampleChannelDataOperationBody(builder: SampleChannelDataResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PAYLOADS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("payloads"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PAYLOADS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PAYLOADS_DESCRIPTOR.index -> builder.payloads =
                    deserializer.deserializeList(PAYLOADS_DESCRIPTOR) {
                        val col0 = mutableListOf<ByteArray>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().decodeBase64Bytes() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwSampleChannelDataError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTAnalyticsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
