// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotanalytics.model.DescribeChannelResponse
import aws.sdk.kotlin.services.iotanalytics.model.IoTAnalyticsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeChannelOperationDeserializer: HttpDeserialize<DescribeChannelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeChannelResponse {
        if (!response.status.isSuccess()) {
            throwDescribeChannelError(context, response)
        }
        val builder = DescribeChannelResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeChannelOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeChannelOperationBody(builder: DescribeChannelResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("channel"))
    val STATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("statistics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNEL_DESCRIPTOR)
        field(STATISTICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNEL_DESCRIPTOR.index -> builder.channel = deserializeChannelDocument(deserializer)
                STATISTICS_DESCRIPTOR.index -> builder.statistics = deserializeChannelStatisticsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeChannelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTAnalyticsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
