// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetResponse
import aws.sdk.kotlin.services.iotanalytics.model.IoTAnalyticsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDatasetOperationDeserializer: HttpDeserialize<CreateDatasetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDatasetResponse {
        if (!response.status.isSuccess()) {
            throwCreateDatasetError(context, response)
        }
        val builder = CreateDatasetResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDatasetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateDatasetOperationBody(builder: CreateDatasetResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATASETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetArn"))
    val DATASETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("datasetName"))
    val RETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("retentionPeriod"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASETARN_DESCRIPTOR)
        field(DATASETNAME_DESCRIPTOR)
        field(RETENTIONPERIOD_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATASETARN_DESCRIPTOR.index -> builder.datasetArn = deserializeString()
                DATASETNAME_DESCRIPTOR.index -> builder.datasetName = deserializeString()
                RETENTIONPERIOD_DESCRIPTOR.index -> builder.retentionPeriod = deserializeRetentionPeriodDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateDatasetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTAnalyticsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
