// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotanalytics.model.BatchPutMessageErrorEntry
import aws.sdk.kotlin.services.iotanalytics.model.BatchPutMessageResponse
import aws.sdk.kotlin.services.iotanalytics.model.IoTAnalyticsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchPutMessageOperationDeserializer: HttpDeserialize<BatchPutMessageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchPutMessageResponse {
        if (!response.status.isSuccess()) {
            throwBatchPutMessageError(context, response)
        }
        val builder = BatchPutMessageResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchPutMessageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeBatchPutMessageOperationBody(builder: BatchPutMessageResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BATCHPUTMESSAGEERRORENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("batchPutMessageErrorEntries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BATCHPUTMESSAGEERRORENTRIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BATCHPUTMESSAGEERRORENTRIES_DESCRIPTOR.index -> builder.batchPutMessageErrorEntries =
                    deserializer.deserializeList(BATCHPUTMESSAGEERRORENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchPutMessageErrorEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchPutMessageErrorEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwBatchPutMessageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IoTAnalyticsException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
