// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



class UpdateDatastoreRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the data store to be updated.
     */
    val datastoreName: String? = builder.datastoreName
    /**
     * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    val datastoreStorage: DatastoreStorage? = builder.datastoreStorage
    /**
     * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
     * The default file format is JSON. You can specify only one format.
     * You can't change the file format after you create the data store.
     */
    val fileFormatConfiguration: FileFormatConfiguration? = builder.fileFormatConfiguration
    /**
     * How long, in days, message data is kept for the data store. The retention period can't be
     * updated if the data store's Amazon S3 storage is customer-managed.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateDatastoreRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDatastoreRequest(")
        append("datastoreName=$datastoreName,")
        append("datastoreStorage=$datastoreStorage,")
        append("fileFormatConfiguration=$fileFormatConfiguration,")
        append("retentionPeriod=$retentionPeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = datastoreName?.hashCode() ?: 0
        result = 31 * result + (datastoreStorage?.hashCode() ?: 0)
        result = 31 * result + (fileFormatConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateDatastoreRequest

        if (datastoreName != other.datastoreName) return false
        if (datastoreStorage != other.datastoreStorage) return false
        if (fileFormatConfiguration != other.fileFormatConfiguration) return false
        if (retentionPeriod != other.retentionPeriod) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateDatastoreRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateDatastoreRequest
        /**
         * The name of the data store to be updated.
         */
        fun datastoreName(datastoreName: String): FluentBuilder
        /**
         * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
         */
        fun datastoreStorage(datastoreStorage: DatastoreStorage): FluentBuilder
        /**
         * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
         * The default file format is JSON. You can specify only one format.
         * You can't change the file format after you create the data store.
         */
        fun fileFormatConfiguration(fileFormatConfiguration: FileFormatConfiguration): FluentBuilder
        /**
         * How long, in days, message data is kept for the data store. The retention period can't be
         * updated if the data store's Amazon S3 storage is customer-managed.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the data store to be updated.
         */
        var datastoreName: String?
        /**
         * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
         */
        var datastoreStorage: DatastoreStorage?
        /**
         * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
         * The default file format is JSON. You can specify only one format.
         * You can't change the file format after you create the data store.
         */
        var fileFormatConfiguration: FileFormatConfiguration?
        /**
         * How long, in days, message data is kept for the data store. The retention period can't be
         * updated if the data store's Amazon S3 storage is customer-managed.
         */
        var retentionPeriod: RetentionPeriod?

        fun build(): UpdateDatastoreRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration] inside the given [block]
         */
        fun fileFormatConfiguration(block: FileFormatConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.fileFormatConfiguration = FileFormatConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var datastoreName: String? = null
        override var datastoreStorage: DatastoreStorage? = null
        override var fileFormatConfiguration: FileFormatConfiguration? = null
        override var retentionPeriod: RetentionPeriod? = null

        constructor(x: UpdateDatastoreRequest) : this() {
            this.datastoreName = x.datastoreName
            this.datastoreStorage = x.datastoreStorage
            this.fileFormatConfiguration = x.fileFormatConfiguration
            this.retentionPeriod = x.retentionPeriod
        }

        override fun build(): UpdateDatastoreRequest = UpdateDatastoreRequest(this)
        override fun datastoreName(datastoreName: String): FluentBuilder = apply { this.datastoreName = datastoreName }
        override fun datastoreStorage(datastoreStorage: DatastoreStorage): FluentBuilder = apply { this.datastoreStorage = datastoreStorage }
        override fun fileFormatConfiguration(fileFormatConfiguration: FileFormatConfiguration): FluentBuilder = apply { this.fileFormatConfiguration = fileFormatConfiguration }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
    }
}
