// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



class UpdateDatasetRequest private constructor(builder: BuilderImpl) {
    /**
     * A list of DatasetAction objects.
     */
    val actions: List<DatasetAction>? = builder.actions
    /**
     * When dataset contents are created, they are delivered to destinations specified
     * here.
     */
    val contentDeliveryRules: List<DatasetContentDeliveryRule>? = builder.contentDeliveryRules
    /**
     * The name of the dataset to update.
     */
    val datasetName: String? = builder.datasetName
    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
     */
    val lateDataRules: List<LateDataRule>? = builder.lateDataRules
    /**
     * How long, in days, dataset contents are kept for the dataset.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod
    /**
     * A list of DatasetTrigger objects. The list can be empty or can contain up to
     * five DatasetTrigger objects.
     */
    val triggers: List<DatasetTrigger>? = builder.triggers
    /**
     * Optional. How many versions of dataset contents are kept. If not specified or set to null,
     * only the latest version plus the latest succeeded version (if they are different) are kept for
     * the time period specified by the retentionPeriod parameter. For more information,
     * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets in the
     * IoT Analytics User Guide.
     */
    val versioningConfiguration: VersioningConfiguration? = builder.versioningConfiguration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateDatasetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDatasetRequest(")
        append("actions=$actions,")
        append("contentDeliveryRules=$contentDeliveryRules,")
        append("datasetName=$datasetName,")
        append("lateDataRules=$lateDataRules,")
        append("retentionPeriod=$retentionPeriod,")
        append("triggers=$triggers,")
        append("versioningConfiguration=$versioningConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (contentDeliveryRules?.hashCode() ?: 0)
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (lateDataRules?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (triggers?.hashCode() ?: 0)
        result = 31 * result + (versioningConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateDatasetRequest

        if (actions != other.actions) return false
        if (contentDeliveryRules != other.contentDeliveryRules) return false
        if (datasetName != other.datasetName) return false
        if (lateDataRules != other.lateDataRules) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (triggers != other.triggers) return false
        if (versioningConfiguration != other.versioningConfiguration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateDatasetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateDatasetRequest
        /**
         * A list of DatasetAction objects.
         */
        fun actions(actions: List<DatasetAction>): FluentBuilder
        /**
         * When dataset contents are created, they are delivered to destinations specified
         * here.
         */
        fun contentDeliveryRules(contentDeliveryRules: List<DatasetContentDeliveryRule>): FluentBuilder
        /**
         * The name of the dataset to update.
         */
        fun datasetName(datasetName: String): FluentBuilder
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
         */
        fun lateDataRules(lateDataRules: List<LateDataRule>): FluentBuilder
        /**
         * How long, in days, dataset contents are kept for the dataset.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
        /**
         * A list of DatasetTrigger objects. The list can be empty or can contain up to
         * five DatasetTrigger objects.
         */
        fun triggers(triggers: List<DatasetTrigger>): FluentBuilder
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null,
         * only the latest version plus the latest succeeded version (if they are different) are kept for
         * the time period specified by the retentionPeriod parameter. For more information,
         * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        fun versioningConfiguration(versioningConfiguration: VersioningConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of DatasetAction objects.
         */
        var actions: List<DatasetAction>?
        /**
         * When dataset contents are created, they are delivered to destinations specified
         * here.
         */
        var contentDeliveryRules: List<DatasetContentDeliveryRule>?
        /**
         * The name of the dataset to update.
         */
        var datasetName: String?
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
         */
        var lateDataRules: List<LateDataRule>?
        /**
         * How long, in days, dataset contents are kept for the dataset.
         */
        var retentionPeriod: RetentionPeriod?
        /**
         * A list of DatasetTrigger objects. The list can be empty or can contain up to
         * five DatasetTrigger objects.
         */
        var triggers: List<DatasetTrigger>?
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null,
         * only the latest version plus the latest succeeded version (if they are different) are kept for
         * the time period specified by the retentionPeriod parameter. For more information,
         * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        var versioningConfiguration: VersioningConfiguration?

        fun build(): UpdateDatasetRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration] inside the given [block]
         */
        fun versioningConfiguration(block: VersioningConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.versioningConfiguration = VersioningConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actions: List<DatasetAction>? = null
        override var contentDeliveryRules: List<DatasetContentDeliveryRule>? = null
        override var datasetName: String? = null
        override var lateDataRules: List<LateDataRule>? = null
        override var retentionPeriod: RetentionPeriod? = null
        override var triggers: List<DatasetTrigger>? = null
        override var versioningConfiguration: VersioningConfiguration? = null

        constructor(x: UpdateDatasetRequest) : this() {
            this.actions = x.actions
            this.contentDeliveryRules = x.contentDeliveryRules
            this.datasetName = x.datasetName
            this.lateDataRules = x.lateDataRules
            this.retentionPeriod = x.retentionPeriod
            this.triggers = x.triggers
            this.versioningConfiguration = x.versioningConfiguration
        }

        override fun build(): UpdateDatasetRequest = UpdateDatasetRequest(this)
        override fun actions(actions: List<DatasetAction>): FluentBuilder = apply { this.actions = actions }
        override fun contentDeliveryRules(contentDeliveryRules: List<DatasetContentDeliveryRule>): FluentBuilder = apply { this.contentDeliveryRules = contentDeliveryRules }
        override fun datasetName(datasetName: String): FluentBuilder = apply { this.datasetName = datasetName }
        override fun lateDataRules(lateDataRules: List<LateDataRule>): FluentBuilder = apply { this.lateDataRules = lateDataRules }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun triggers(triggers: List<DatasetTrigger>): FluentBuilder = apply { this.triggers = triggers }
        override fun versioningConfiguration(versioningConfiguration: VersioningConfiguration): FluentBuilder = apply { this.versioningConfiguration = versioningConfiguration }
    }
}
