// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



class UpdateChannelRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the channel to be updated.
     */
    val channelName: String? = builder.channelName
    /**
     * Where channel data is stored. You can choose one of serviceManagedS3 or
     * customerManagedS3 storage. If not specified, the default is
     * serviceManagedS3. You can't change this storage option after the channel is
     * created.
     */
    val channelStorage: ChannelStorage? = builder.channelStorage
    /**
     * How long, in days, message data is kept for the channel. The retention period can't be
     * updated if the channel's Amazon S3 storage is customer-managed.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateChannelRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateChannelRequest(")
        append("channelName=$channelName,")
        append("channelStorage=$channelStorage,")
        append("retentionPeriod=$retentionPeriod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName?.hashCode() ?: 0
        result = 31 * result + (channelStorage?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateChannelRequest

        if (channelName != other.channelName) return false
        if (channelStorage != other.channelStorage) return false
        if (retentionPeriod != other.retentionPeriod) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateChannelRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateChannelRequest
        /**
         * The name of the channel to be updated.
         */
        fun channelName(channelName: String): FluentBuilder
        /**
         * Where channel data is stored. You can choose one of serviceManagedS3 or
         * customerManagedS3 storage. If not specified, the default is
         * serviceManagedS3. You can't change this storage option after the channel is
         * created.
         */
        fun channelStorage(channelStorage: ChannelStorage): FluentBuilder
        /**
         * How long, in days, message data is kept for the channel. The retention period can't be
         * updated if the channel's Amazon S3 storage is customer-managed.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the channel to be updated.
         */
        var channelName: String?
        /**
         * Where channel data is stored. You can choose one of serviceManagedS3 or
         * customerManagedS3 storage. If not specified, the default is
         * serviceManagedS3. You can't change this storage option after the channel is
         * created.
         */
        var channelStorage: ChannelStorage?
        /**
         * How long, in days, message data is kept for the channel. The retention period can't be
         * updated if the channel's Amazon S3 storage is customer-managed.
         */
        var retentionPeriod: RetentionPeriod?

        fun build(): UpdateChannelRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage] inside the given [block]
         */
        fun channelStorage(block: ChannelStorage.DslBuilder.() -> kotlin.Unit) {
            this.channelStorage = ChannelStorage.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var channelName: String? = null
        override var channelStorage: ChannelStorage? = null
        override var retentionPeriod: RetentionPeriod? = null

        constructor(x: UpdateChannelRequest) : this() {
            this.channelName = x.channelName
            this.channelStorage = x.channelStorage
            this.retentionPeriod = x.retentionPeriod
        }

        override fun build(): UpdateChannelRequest = UpdateChannelRequest(this)
        override fun channelName(channelName: String): FluentBuilder = apply { this.channelName = channelName }
        override fun channelStorage(channelStorage: ChannelStorage): FluentBuilder = apply { this.channelStorage = channelStorage }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
    }
}
